/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl.headers;

import io.netty.handler.codec.http.HttpHeaders;
import java.util.TreeSet;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getHeaderNames", receiver=@Receiver(type=TypeKind.STRUCT, structType="Entity", structPackage="ballerina.mime"), returnType={@ReturnType(type=TypeKind.ARRAY)}, isPublic=true)
public class GetHeaderNames
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        BStruct entityStruct = (BStruct)context.getRefArgument(0);
        BStringArray bStringArray = new BStringArray();
        if (entityStruct.getNativeData("entity_headers") == null) {
            context.setReturnValues(new BValue[]{bStringArray});
            return;
        }
        HttpHeaders httpHeaders = (HttpHeaders)entityStruct.getNativeData("entity_headers");
        if (httpHeaders != null && !httpHeaders.isEmpty()) {
            int i = 0;
            TreeSet<String> distinctNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (String headerName : httpHeaders.names()) {
                distinctNames.add(headerName);
            }
            for (String headerName : distinctNames) {
                bStringArray.add((long)i, headerName);
                ++i;
            }
            context.setReturnValues(new BValue[]{bStringArray});
        } else {
            context.setReturnValues(new BValue[]{bStringArray});
        }
    }
}

