/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import java.io.InputStream;
import java.util.Locale;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.wso2.transport.http.netty.message.FullHttpMessageListener;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public abstract class AbstractGetPayloadHandler {
    static void constructNonBlockingDataSource(final NonBlockingCallback callback, final ObjectValue entity, final SourceType sourceType) {
        HttpCarbonMessage inboundMessage = AbstractGetPayloadHandler.extractTransportMessageFromEntity(entity);
        inboundMessage.getFullHttpCarbonMessage().addListener(new FullHttpMessageListener(){

            public void onComplete(HttpCarbonMessage inboundMessage) {
                Object dataSource = null;
                HttpMessageDataStreamer dataStreamer = new HttpMessageDataStreamer(inboundMessage);
                InputStream inputStream = dataStreamer.getInputStream();
                try {
                    switch (sourceType) {
                        case JSON: {
                            dataSource = EntityBodyHandler.constructJsonDataSource(entity, inputStream);
                            break;
                        }
                        case TEXT: {
                            dataSource = EntityBodyHandler.constructStringDataSource(entity, inputStream);
                            break;
                        }
                        case XML: {
                            dataSource = EntityBodyHandler.constructXmlDataSource(entity, inputStream);
                            break;
                        }
                        case BLOB: {
                            dataSource = EntityBodyHandler.constructBlobDataSource(inputStream);
                        }
                    }
                    AbstractGetPayloadHandler.updateDataSourceAndNotify(callback, entity, dataSource);
                }
                catch (Exception e) {
                    AbstractGetPayloadHandler.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting " + sourceType.toString().toLowerCase(Locale.ENGLISH) + " data from entity: " + e.getMessage());
                }
            }

            public void onError(Exception ex) {
                AbstractGetPayloadHandler.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting content from message : " + ex.getMessage());
            }
        });
    }

    private static void setReturnValuesAndNotify(NonBlockingCallback callback, Object result) {
        callback.setReturnValues(result);
        callback.notifySuccess();
    }

    static Object createParsingEntityBodyFailedErrorAndNotify(NonBlockingCallback callback, String errMsg) {
        ErrorValue error = MimeUtil.createError("{ballerina/mime}ParsingEntityBodyFailed", errMsg);
        if (callback != null) {
            AbstractGetPayloadHandler.setReturnValuesAndNotify(callback, error);
            return null;
        }
        return error;
    }

    static void updateDataSource(ObjectValue entityObj, Object result) {
        EntityBodyHandler.addMessageDataSource(entityObj, result);
        entityObj.addNativeData("entity_byte_channel", null);
    }

    private static void updateDataSourceAndNotify(NonBlockingCallback callback, ObjectValue entityObj, Object result) {
        AbstractGetPayloadHandler.updateDataSource(entityObj, result);
        AbstractGetPayloadHandler.setReturnValuesAndNotify(callback, result);
    }

    private static HttpCarbonMessage extractTransportMessageFromEntity(ObjectValue entityObj) {
        HttpCarbonMessage message = (HttpCarbonMessage)entityObj.getNativeData("transport_message");
        if (message != null) {
            return message;
        }
        throw new BallerinaIOException("Empty content");
    }

    static enum SourceType {
        JSON,
        XML,
        TEXT,
        BLOB;

    }
}

