/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.mime.util.EntityBodyChannel;
import org.ballerinalang.mime.util.EntityWrapper;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.mime.util.MultipartDataSource;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getBodyPartsAsChannel", receiver=@Receiver(type=TypeKind.OBJECT, structType="Entity", structPackage="ballerina/mime"), returnType={@ReturnType(type=TypeKind.ARRAY), @ReturnType(type=TypeKind.RECORD)}, isPublic=true)
public class GetBodyPartsAsChannel {
    private static final Logger log = LoggerFactory.getLogger(GetBodyPartsAsChannel.class);

    public static Object getBodyPartsAsChannel(Strand strand, ObjectValue entityObj) {
        try {
            String contentType = MimeUtil.getContentTypeWithParameters(entityObj);
            if (HeaderUtil.isMultipart(contentType)) {
                String boundaryValue = HeaderUtil.extractBoundaryParameter(contentType);
                String multipartDataBoundary = boundaryValue != null ? boundaryValue : MimeUtil.getNewMultipartDelimiter();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                MultipartDataSource multipartDataSource = new MultipartDataSource(entityObj, multipartDataBoundary);
                multipartDataSource.serialize(outputStream);
                EntityBodyChannel entityBodyChannel = new EntityBodyChannel(new ByteArrayInputStream(outputStream.toByteArray()));
                ObjectValue byteChannelObj = BallerinaValues.createObjectValue((String)"ballerina/io", (String)"ReadableByteChannel", (Object[])new Object[0]);
                byteChannelObj.addNativeData("byteChannel", (Object)new EntityWrapper(entityBodyChannel));
                return byteChannelObj;
            }
            return MimeUtil.createError("{ballerina/mime}ParsingEntityBodyFailed", "Entity doesn't contain body parts");
        }
        catch (Throwable err) {
            log.error("Error occurred while constructing a byte channel out of body parts", err);
            return MimeUtil.createError("{ballerina/mime}ParsingEntityBodyFailed", "Error occurred while constructing a byte channel out of body parts : " + err.getMessage());
        }
    }
}

