/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.mime.nativeimpl.AbstractGetPayloadHandler;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getJson", receiver=@Receiver(type=TypeKind.OBJECT, structType="Entity", structPackage="ballerina/mime"), returnType={@ReturnType(type=TypeKind.JSON), @ReturnType(type=TypeKind.RECORD)}, isPublic=true)
public class GetJson
extends AbstractGetPayloadHandler {
    public static Object getJson(Strand strand, ObjectValue entityObj) {
        NonBlockingCallback callback = null;
        RefValue result = null;
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (dataSource != null) {
                if (GetJson.isJSON(dataSource)) {
                    result = (RefValue)dataSource;
                } else {
                    String payload = MimeUtil.getMessageAsString(dataSource);
                    result = (RefValue)JSONParser.parse((String)payload);
                }
                return result;
            }
            if (EntityBodyHandler.isStreamingRequired(entityObj)) {
                result = (RefValue)EntityBodyHandler.constructJsonDataSource(entityObj);
                GetJson.updateDataSource(entityObj, result);
            } else {
                callback = new NonBlockingCallback(strand);
                GetJson.constructNonBlockingDataSource(callback, entityObj, AbstractGetPayloadHandler.SourceType.JSON);
            }
        }
        catch (Exception ex) {
            return GetJson.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting json data from entity: " + ex.getMessage());
        }
        return result;
    }

    private static boolean isJSON(Object value) {
        BType objectType = TypeChecker.getType((Object)value);
        return objectType.getTag() != 5 && MimeUtil.isJSONCompatible(objectType);
    }
}

