/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.mime.nativeimpl.AbstractGetPayloadHandler;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getText", receiver=@Receiver(type=TypeKind.OBJECT, structType="Entity", structPackage="ballerina/mime"), returnType={@ReturnType(type=TypeKind.STRING), @ReturnType(type=TypeKind.RECORD)}, isPublic=true)
public class GetText
extends AbstractGetPayloadHandler {
    public static Object getText(Strand strand, ObjectValue entityObj) {
        NonBlockingCallback callback = null;
        String result = null;
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (dataSource != null) {
                return MimeUtil.getMessageAsString(dataSource);
            }
            if (EntityBodyHandler.isStreamingRequired(entityObj)) {
                result = EntityBodyHandler.constructStringDataSource(entityObj);
                GetText.updateDataSource(entityObj, result);
            } else {
                callback = new NonBlockingCallback(strand);
                GetText.constructNonBlockingDataSource(callback, entityObj, AbstractGetPayloadHandler.SourceType.TEXT);
            }
        }
        catch (Exception ex) {
            return GetText.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting text data from entity : " + ex.getMessage());
        }
        return result;
    }
}

