/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.mime.nativeimpl.AbstractGetPayloadHandler;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getXml", receiver=@Receiver(type=TypeKind.OBJECT, structType="Entity", structPackage="ballerina/mime"), returnType={@ReturnType(type=TypeKind.XML), @ReturnType(type=TypeKind.RECORD)}, isPublic=true)
public class GetXml
extends AbstractGetPayloadHandler {
    public static Object getXml(Strand strand, ObjectValue entityObj) {
        NonBlockingCallback callback = null;
        XMLValue result = null;
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (dataSource != null) {
                if (dataSource instanceof XMLValue) {
                    result = (XMLValue)dataSource;
                } else {
                    String payload = MimeUtil.getMessageAsString(dataSource);
                    result = XMLFactory.parse((String)payload);
                }
                return result;
            }
            if (EntityBodyHandler.isStreamingRequired(entityObj)) {
                result = EntityBodyHandler.constructXmlDataSource(entityObj);
                GetXml.updateDataSource(entityObj, result);
            } else {
                callback = new NonBlockingCallback(strand);
                GetXml.constructNonBlockingDataSource(callback, entityObj, AbstractGetPayloadHandler.SourceType.XML);
            }
        }
        catch (Exception ex) {
            return GetXml.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting xml data from entity : " + ex.getMessage());
        }
        return result;
    }
}

