/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.mime.util.EntityBodyChannel;
import org.ballerinalang.mime.util.EntityWrapper;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeEntityWrapper;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.mime.util.MultipartDecoder;
import org.ballerinalang.stdlib.io.channels.TempFileIOChannel;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.jvnet.mimepull.MIMEPart;

public class EntityBodyHandler {
    public static EntityWrapper getEntityWrapper(String textPayload) {
        return new EntityWrapper(new EntityBodyChannel(new ByteArrayInputStream(textPayload.getBytes(StandardCharsets.UTF_8))));
    }

    public static TempFileIOChannel getByteChannelForTempFile(String temporaryFilePath) {
        FileChannel fileChannel;
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        options.add(StandardOpenOption.READ);
        Path path = Paths.get(temporaryFilePath, new String[0]);
        try {
            fileChannel = (FileChannel)Files.newByteChannel(path, options, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BallerinaException("Error occurred while creating a file channel from a temporary file");
        }
        return new TempFileIOChannel(fileChannel, temporaryFilePath);
    }

    public static Object getMessageDataSource(ObjectValue entityObj) {
        return entityObj.getNativeData("message_datasource");
    }

    public static void addMessageDataSource(ObjectValue entityObj, Object messageDataSource) {
        entityObj.addNativeData("message_datasource", messageDataSource);
    }

    public static ArrayValue constructBlobDataSource(ObjectValue entityObj) throws IOException {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel == null) {
            return new ArrayValue(new byte[0]);
        }
        ArrayValue byteData = EntityBodyHandler.constructBlobDataSource(byteChannel.getInputStream());
        byteChannel.close();
        return byteData;
    }

    public static ArrayValue constructBlobDataSource(InputStream inputStream) {
        byte[] byteData;
        try {
            byteData = MimeUtil.getByteArray(inputStream);
        }
        catch (IOException ex) {
            throw new BallerinaException("Error occurred while reading input stream :" + ex.getMessage());
        }
        return new ArrayValue(byteData);
    }

    public static Object constructJsonDataSource(ObjectValue entityObj) {
        try {
            Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
            if (byteChannel == null) {
                return null;
            }
            Object jsonData = EntityBodyHandler.constructJsonDataSource(entityObj, byteChannel.getInputStream());
            byteChannel.close();
            return jsonData;
        }
        catch (IOException e) {
            throw new BallerinaIOException("Error occurred while closing connection", (Throwable)e);
        }
    }

    public static Object constructJsonDataSource(ObjectValue entity, InputStream inputStream) {
        String charsetValue;
        String contentTypeValue = HeaderUtil.getHeaderValue(entity, HttpHeaderNames.CONTENT_TYPE.toString());
        Object jsonData = MimeUtil.isNotNullAndEmpty(contentTypeValue) ? (MimeUtil.isNotNullAndEmpty(charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset")) ? JSONParser.parse((InputStream)inputStream, (String)charsetValue) : JSONParser.parse((InputStream)inputStream)) : JSONParser.parse((InputStream)inputStream);
        return jsonData;
    }

    public static XMLValue constructXmlDataSource(ObjectValue entityObj) {
        try {
            Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
            if (byteChannel == null) {
                throw new BallerinaIOException("Empty xml payload");
            }
            XMLValue xmlContent = EntityBodyHandler.constructXmlDataSource(entityObj, byteChannel.getInputStream());
            byteChannel.close();
            return xmlContent;
        }
        catch (IOException e) {
            throw new BallerinaIOException("Error occurred while closing the channel", (Throwable)e);
        }
    }

    public static XMLValue constructXmlDataSource(ObjectValue entityObj, InputStream inputStream) {
        String charsetValue;
        String contentTypeValue = HeaderUtil.getHeaderValue(entityObj, HttpHeaderNames.CONTENT_TYPE.toString());
        XMLValue xmlContent = MimeUtil.isNotNullAndEmpty(contentTypeValue) ? (MimeUtil.isNotNullAndEmpty(charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset")) ? XMLFactory.parse((InputStream)inputStream, (String)charsetValue) : XMLFactory.parse((InputStream)inputStream)) : XMLFactory.parse((InputStream)inputStream);
        return xmlContent;
    }

    public static String constructStringDataSource(ObjectValue entityObj) {
        try {
            Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
            if (byteChannel == null) {
                throw new BallerinaIOException("String payload is null");
            }
            String textContent = EntityBodyHandler.constructStringDataSource(entityObj, byteChannel.getInputStream());
            byteChannel.close();
            return textContent;
        }
        catch (IOException e) {
            throw new BallerinaIOException("Error occurred while closing the channel", (Throwable)e);
        }
    }

    public static String constructStringDataSource(ObjectValue entity, InputStream inputStream) {
        String charsetValue;
        String contentTypeValue = HeaderUtil.getHeaderValue(entity, HttpHeaderNames.CONTENT_TYPE.toString());
        String textContent = MimeUtil.isNotNullAndEmpty(contentTypeValue) ? (MimeUtil.isNotNullAndEmpty(charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset")) ? StringUtils.getStringFromInputStream((InputStream)inputStream, (String)charsetValue) : StringUtils.getStringFromInputStream((InputStream)inputStream)) : StringUtils.getStringFromInputStream((InputStream)inputStream);
        return textContent;
    }

    public static boolean checkEntityBodyAvailability(ObjectValue entityObj) {
        return entityObj.getNativeData("entity_byte_channel") != null || EntityBodyHandler.getMessageDataSource(entityObj) != null || entityObj.getNativeData("body_parts") != null;
    }

    public static boolean isStreamingRequired(ObjectValue entity) {
        return entity.getNativeData("entity_byte_channel") != null || entity.getNativeData("body_parts") != null;
    }

    static void setPartsToTopLevelEntity(ObjectValue entity, ArrayList<ObjectValue> bodyParts) {
        if (!bodyParts.isEmpty()) {
            BObjectType typeOfBodyPart = bodyParts.get(0).getType();
            Object[] result = bodyParts.toArray(new ObjectValue[bodyParts.size()]);
            ArrayValue partsArray = new ArrayValue(result, (BType)new BArrayType((BType)typeOfBodyPart));
            entity.addNativeData("body_parts", (Object)partsArray);
        }
    }

    public static void populateBodyContent(ObjectValue bodyPart, MIMEPart mimePart) {
        bodyPart.addNativeData("entity_byte_channel", (Object)new MimeEntityWrapper(new EntityBodyChannel(mimePart.readOnce()), mimePart));
    }

    public static void writeByteChannelToOutputStream(ObjectValue entityObj, OutputStream messageOutputStream) throws IOException {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel != null) {
            MimeUtil.writeInputToOutputStream(byteChannel.getInputStream(), messageOutputStream);
            byteChannel.close();
            entityObj.addNativeData("entity_byte_channel", null);
        }
    }

    public static void decodeEntityBody(ObjectValue entityObj, Channel byteChannel) {
        String contentType = MimeUtil.getContentTypeWithParameters(entityObj);
        if (!MimeUtil.isNotNullAndEmpty(contentType) || !contentType.startsWith("multipart/")) {
            return;
        }
        MultipartDecoder.parseBody(entityObj, contentType, byteChannel.getInputStream());
    }

    public static ArrayValue getBodyPartArray(ObjectValue entityObj) {
        return entityObj.getNativeData("body_parts") != null ? (ArrayValue)entityObj.getNativeData("body_parts") : new ArrayValue();
    }

    public static Channel getByteChannel(ObjectValue entityObj) {
        return entityObj.getNativeData("entity_byte_channel") != null ? (Channel)entityObj.getNativeData("entity_byte_channel") : null;
    }
}

