/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.util;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.MimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartDataSource
implements RefValue {
    private static final Logger log = LoggerFactory.getLogger(MultipartDataSource.class);
    private ObjectValue parentEntity;
    private String boundaryString;
    private OutputStream outputStream;
    private static final String DASH_BOUNDARY = "--";
    private static final String CRLF_POST_DASH = "\r\n--";
    private static final String CRLF_PRE_DASH = "--\r\n";
    private static final String CRLF = "\r\n";
    private static final char COLON = ':';
    private static final char SPACE = ' ';

    public MultipartDataSource(ObjectValue entityStruct, String boundaryString) {
        this.parentEntity = entityStruct;
        this.boundaryString = boundaryString;
    }

    public void serialize(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.serializeBodyPart(outputStream, this.boundaryString, this.parentEntity);
    }

    private void serializeBodyPart(OutputStream outputStream, String parentBoundaryString, ObjectValue parentBodyPart) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, Charset.defaultCharset()));
        ArrayValue childParts = parentBodyPart.getNativeData("body_parts") != null ? (ArrayValue)parentBodyPart.getNativeData("body_parts") : null;
        try {
            if (childParts == null) {
                return;
            }
            boolean firstPart = true;
            for (int i = 0; i < childParts.size(); ++i) {
                ObjectValue childPart = (ObjectValue)childParts.getRefValue((long)i);
                if (firstPart) {
                    firstPart = false;
                    writer.write(DASH_BOUNDARY);
                } else {
                    writer.write(CRLF_POST_DASH);
                }
                writer.write(parentBoundaryString);
                writer.write(CRLF);
                this.checkForNestedParts(writer, childPart);
                this.writeBodyContent(outputStream, childPart);
            }
            this.writeFinalBoundaryString(writer, parentBoundaryString);
        }
        catch (IOException e) {
            log.error("Error occurred while writing body parts to outputstream", (Object)e.getMessage());
        }
    }

    private void checkForNestedParts(Writer writer, ObjectValue childPart) throws IOException {
        ArrayValue nestedParts;
        String childBoundaryString = null;
        if (MimeUtil.isNestedPartsAvailable(childPart)) {
            childBoundaryString = MimeUtil.getNewMultipartDelimiter();
            ObjectValue mediaType = (ObjectValue)childPart.get("cType");
            Object paramMap = mediaType.get("parameters") != null ? (MapValue)mediaType.get("parameters") : new MapValueImpl((BType)new BMapType(BTypes.typeString));
            paramMap.put((Object)"boundary", (Object)childBoundaryString);
            mediaType.set("parameters", paramMap);
        }
        this.writeBodyPartHeaders(writer, childPart);
        if (childBoundaryString != null && (nestedParts = (ArrayValue)childPart.getNativeData("body_parts")) != null && nestedParts.size() > 0) {
            this.serializeBodyPart(this.outputStream, childBoundaryString, childPart);
        }
    }

    private void writeBodyPartHeaders(Writer writer, ObjectValue bodyPart) throws IOException {
        Object contentId;
        DefaultHttpHeaders httpHeaders;
        if (bodyPart.getNativeData("entity_headers") != null) {
            httpHeaders = (HttpHeaders)bodyPart.getNativeData("entity_headers");
        } else {
            httpHeaders = new DefaultHttpHeaders();
            bodyPart.addNativeData("entity_headers", (Object)httpHeaders);
        }
        String contentType = MimeUtil.getContentTypeWithParameters(bodyPart);
        httpHeaders.set(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)contentType);
        String contentDisposition = MimeUtil.getContentDisposition(bodyPart);
        if (!contentDisposition.isEmpty()) {
            httpHeaders.set(HttpHeaderNames.CONTENT_DISPOSITION.toString(), (Object)contentDisposition);
        }
        if ((contentId = bodyPart.get("cId")) != null && !contentId.toString().isEmpty()) {
            httpHeaders.set("content-id", (Object)contentId.toString());
        }
        Iterator iterator = httpHeaders.iteratorAsString();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            writer.write((String)entry.getKey());
            writer.write(58);
            writer.write(32);
            writer.write((String)entry.getValue());
            writer.write(CRLF);
        }
        writer.write(CRLF);
        writer.flush();
    }

    private void writeFinalBoundaryString(Writer writer, String boundaryString) throws IOException {
        writer.write(CRLF_POST_DASH);
        writer.write(boundaryString);
        writer.write(CRLF_PRE_DASH);
        writer.flush();
    }

    private void writeBodyContent(OutputStream outputStream, ObjectValue bodyPart) throws IOException {
        Object messageDataSource = EntityBodyHandler.getMessageDataSource(bodyPart);
        if (messageDataSource != null) {
            if (messageDataSource instanceof String || messageDataSource instanceof Long || messageDataSource instanceof Double || messageDataSource instanceof Integer || messageDataSource instanceof Boolean) {
                outputStream.write(messageDataSource.toString().getBytes(Charset.defaultCharset()));
            } else {
                ((RefValue)messageDataSource).serialize(outputStream);
            }
        } else {
            EntityBodyHandler.writeByteChannelToOutputStream(bodyPart, outputStream);
        }
    }

    public String stringValue() {
        return null;
    }

    public BType getType() {
        return null;
    }

    public Object copy(Map<Object, Object> refs) {
        return null;
    }

    public Object frozenCopy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }
}

