/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import java.util.Locale;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.Channel;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getBodyParts", receiver=@Receiver(type=TypeKind.OBJECT, structType="Entity", structPackage="ballerina/mime"), returnType={@ReturnType(type=TypeKind.ARRAY), @ReturnType(type=TypeKind.RECORD)}, isPublic=true)
public class GetBodyParts {
    public static Object getBodyParts(Strand strand, ObjectValue entityObj) {
        try {
            String baseType = HeaderUtil.getBaseType(entityObj);
            if (baseType != null && (baseType.toLowerCase(Locale.getDefault()).startsWith("multipart/") || baseType.toLowerCase(Locale.getDefault()).startsWith("message/"))) {
                Channel byteChannel;
                ArrayValue partsArray = EntityBodyHandler.getBodyPartArray(entityObj);
                if ((partsArray == null || partsArray.size() < 1) && (byteChannel = EntityBodyHandler.getByteChannel(entityObj)) != null) {
                    EntityBodyHandler.decodeEntityBody(entityObj, byteChannel);
                    partsArray = EntityBodyHandler.getBodyPartArray(entityObj);
                    entityObj.addNativeData("entity_byte_channel", null);
                }
                return partsArray;
            }
            return MimeUtil.createError("{ballerina/mime}ParsingEntityBodyFailed", "Entity body is not a type of composite media type. Received content-type : " + baseType);
        }
        catch (Throwable e) {
            return MimeUtil.createError("{ballerina/mime}ParsingEntityBodyFailed", "Error occurred while extracting body parts from entity: " + e.getMessage());
        }
    }
}

