/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.nio.charset.Charset;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.mime.nativeimpl.AbstractGetPayloadHandler;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getByteArray", receiver=@Receiver(type=TypeKind.OBJECT, structType="Entity", structPackage="ballerina/mime"), returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.BYTE), @ReturnType(type=TypeKind.RECORD)}, isPublic=true)
public class GetByteArray
extends AbstractGetPayloadHandler {
    public static Object getByteArray(Strand strand, ObjectValue entityObj) {
        NonBlockingCallback callback = null;
        ArrayValue result = null;
        try {
            Object messageDataSource = EntityBodyHandler.getMessageDataSource(entityObj);
            if (messageDataSource != null) {
                if (messageDataSource instanceof ArrayValue) {
                    result = (ArrayValue)messageDataSource;
                } else {
                    String contentTypeValue = HeaderUtil.getHeaderValue(entityObj, HttpHeaderNames.CONTENT_TYPE.toString());
                    if (MimeUtil.isNotNullAndEmpty(contentTypeValue)) {
                        String charsetValue = MimeUtil.getContentTypeParamValue(contentTypeValue, "charset");
                        result = MimeUtil.isNotNullAndEmpty(charsetValue) ? new ArrayValue(messageDataSource.toString().getBytes(charsetValue)) : new ArrayValue(messageDataSource.toString().getBytes(Charset.defaultCharset()));
                    }
                }
                return result != null ? result : new ArrayValue(new byte[0]);
            }
            Object transportMessage = entityObj.getNativeData("transport_message");
            if (EntityBodyHandler.isStreamingRequired(entityObj) || transportMessage == null) {
                result = EntityBodyHandler.constructBlobDataSource(entityObj);
                GetByteArray.updateDataSource(entityObj, result);
            } else {
                callback = new NonBlockingCallback(strand);
                GetByteArray.constructNonBlockingDataSource(callback, entityObj, AbstractGetPayloadHandler.SourceType.BLOB);
            }
        }
        catch (Exception ex) {
            GetByteArray.createParsingEntityBodyFailedErrorAndNotify(callback, "Error occurred while extracting blob data from entity : " + ex.getMessage());
        }
        return result;
    }
}

