/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.mime.nativeimpl;

import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.mime.util.EntityBodyChannel;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.EntityWrapper;
import org.ballerinalang.mime.util.MimeUtil;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

@BallerinaFunction(orgName="ballerina", packageName="mime", functionName="getByteChannel", receiver=@Receiver(type=TypeKind.OBJECT, structType="Entity", structPackage="ballerina/mime"), returnType={@ReturnType(type=TypeKind.RECORD), @ReturnType(type=TypeKind.RECORD)}, isPublic=true)
public class GetByteChannel {
    public static Object getByteChannel(Strand strand, ObjectValue entityObj) {
        try {
            ObjectValue byteChannelObj = BallerinaValues.createObjectValue((String)"ballerina/io", (String)"ReadableByteChannel", (Object[])new Object[0]);
            GetByteChannel.populateEntityWithByteChannel(entityObj);
            Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
            if (byteChannel != null) {
                byteChannelObj.addNativeData("byteChannel", (Object)byteChannel);
                return byteChannelObj;
            }
            if (EntityBodyHandler.getMessageDataSource(entityObj) != null) {
                return MimeUtil.createError("{ballerina/mime}ParsingEntityBodyFailed", "Byte channel is not available but payload can be obtain either as xml, json, string or byte[] type");
            }
            if (EntityBodyHandler.getBodyPartArray(entityObj) != null && EntityBodyHandler.getBodyPartArray(entityObj).size() != 0) {
                return MimeUtil.createError("{ballerina/mime}ParsingEntityBodyFailed", "Byte channel is not available since payload contains a set of body parts");
            }
            return MimeUtil.createError("{ballerina/mime}ParsingEntityBodyFailed", "Byte channel is not available as payload");
        }
        catch (Throwable e) {
            return MimeUtil.createError("{ballerina/mime}ParsingEntityBodyFailed", "Error occurred while constructing byte channel from entity body : " + e.getMessage());
        }
    }

    private static void populateEntityWithByteChannel(ObjectValue entity) {
        HttpCarbonMessage httpCarbonMessage = (HttpCarbonMessage)entity.getNativeData("transport_message");
        if (httpCarbonMessage == null) {
            return;
        }
        HttpMessageDataStreamer httpMessageDataStreamer = new HttpMessageDataStreamer(httpCarbonMessage);
        long contentLength = MimeUtil.extractContentLength(httpCarbonMessage);
        if (contentLength > 0L) {
            entity.addNativeData("entity_byte_channel", (Object)new EntityWrapper(new EntityBodyChannel(httpMessageDataStreamer.getInputStream())));
        }
    }
}

