/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.database.mysql;

import java.util.UUID;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.database.sql.Constants;
import org.ballerinalang.database.sql.SQLDatasourceUtils;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;

@BallerinaFunction(orgName="ballerina", packageName="mysql", functionName="createClient", args={@Argument(name="config", type=TypeKind.RECORD, structType="ClientEndpointConfiguration")}, isPublic=true)
public class CreateClient
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        BMap clientEndpointConfig = (BMap)context.getRefArgument(0);
        BMap globalPoolOptions = (BMap)context.getRefArgument(1);
        BMap dbOptions = (BMap)clientEndpointConfig.get((Object)"dbOptions");
        String urlOptions = "";
        if (dbOptions != null) {
            urlOptions = SQLDatasourceUtils.createJDBCDbOptions((String)"?", (String)"&", (BMap)dbOptions);
        }
        BMap sqlClient = SQLDatasourceUtils.createServerBasedDBClient((Context)context, (String)"MYSQL", (BMap)clientEndpointConfig, (String)urlOptions, (BMap)globalPoolOptions);
        sqlClient.addNativeData(Constants.CONNECTOR_ID_KEY, (Object)UUID.randomUUID().toString());
        context.setReturnValues(new BValue[]{sqlClient});
    }
}

