/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats;

import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.util.AbstractTransportCompilerPlugin;

public abstract class AbstractNatsConsumerServiceCompilerPlugin
extends AbstractTransportCompilerPlugin {
    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        this.validateAnnotationPresence(serviceNode, annotations);
        List resources = serviceNode.getResources();
        if (resources.size() != 2) {
            this.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), "Exactly two resource functions should be present in the service");
        }
        resources.forEach(resource -> this.validateResourceFunctionSyntax((BLangFunction)resource, serviceNode));
    }

    public abstract void validateAnnotationPresence(ServiceNode var1, List<AnnotationAttachmentNode> var2);

    public abstract void logDiagnostic(Diagnostic.Kind var1, Diagnostic.DiagnosticPosition var2, String var3);

    public abstract void validateMessageParameter(BLangSimpleVariable var1, BLangFunction var2, String var3);

    public abstract String getInvalidMessageResourceSignatureErrorMessage(ServiceNode var1, BLangFunction var2);

    public abstract String getInvalidErrorResourceSignatureErrorMessage(ServiceNode var1, BLangFunction var2);

    private void validateResourceFunctionSyntax(BLangFunction resourceFunction, ServiceNode serviceNode) {
        String resourceFunctionName;
        switch (resourceFunctionName = resourceFunction.getName().getValue()) {
            case "onMessage": {
                this.validateOnMessageResource(serviceNode, resourceFunction);
                break;
            }
            case "onError": {
                this.validateOnErrorResource(serviceNode, resourceFunction);
                break;
            }
            default: {
                String errorMessage = "Invalid resource function name %s in service %s";
                this.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resourceFunction.getPosition(), String.format(errorMessage, resourceFunctionName, serviceNode.getName().getValue()));
            }
        }
    }

    private void validateOnMessageResource(ServiceNode serviceNode, BLangFunction resourceFunction) {
        String errorMessage = this.getInvalidMessageResourceSignatureErrorMessage(serviceNode, resourceFunction);
        List functionParameters = resourceFunction.getParameters();
        if (functionParameters.size() == 1) {
            BLangSimpleVariable firstParameter = (BLangSimpleVariable)functionParameters.get(0);
            this.validateMessageParameter(firstParameter, resourceFunction, errorMessage);
        } else if (functionParameters.size() == 2) {
            BLangSimpleVariable firstParameter = (BLangSimpleVariable)functionParameters.get(0);
            this.validateMessageParameter(firstParameter, resourceFunction, errorMessage);
            BLangSimpleVariable secondParamter = (BLangSimpleVariable)functionParameters.get(1);
            this.validateDataTypeParameter(secondParamter, resourceFunction, errorMessage);
        } else {
            this.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resourceFunction.getPosition(), errorMessage);
        }
    }

    private void validateDataTypeParameter(BLangSimpleVariable secondParameter, BLangFunction resourceFunction, String errorMessage) {
        BType secondParamType = secondParameter.getTypeNode().type;
        int secondParamTypeTag = secondParamType.tag;
        if (secondParamTypeTag == 19) {
            BType elementType = ((BArrayType)secondParamType).getElementType();
            if (elementType.tag != 2) {
                this.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resourceFunction.getPosition(), errorMessage);
            }
        } else if (secondParamTypeTag != 6 && secondParamTypeTag != 5 && secondParamTypeTag != 1 && secondParamTypeTag != 3 && secondParamTypeTag != 4 && secondParamTypeTag != 8 && secondParamTypeTag != 7 && secondParamTypeTag != 12) {
            this.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resourceFunction.getPosition(), errorMessage);
        }
    }

    private void validateOnErrorResource(ServiceNode serviceNode, BLangFunction resourceFunction) {
        String errorMessage = this.getInvalidErrorResourceSignatureErrorMessage(serviceNode, resourceFunction);
        List functionParameters = resourceFunction.getParameters();
        if (functionParameters.size() == 2) {
            BLangSimpleVariable firstParameter = (BLangSimpleVariable)functionParameters.get(0);
            this.validateMessageParameter(firstParameter, resourceFunction, errorMessage);
            BLangSimpleVariable secondParameter = (BLangSimpleVariable)functionParameters.get(1);
            this.validateErrorParameter(secondParameter, resourceFunction, errorMessage);
        } else {
            this.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resourceFunction.getPosition(), errorMessage);
        }
    }

    private void validateErrorParameter(BLangSimpleVariable parameterUnderValidation, BLangFunction resourceFunction, String errorMessage) {
        BType parameterType = parameterUnderValidation.getTypeNode().type;
        int parameterTypeTag = parameterType.tag;
        if (parameterTypeTag != 27) {
            this.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resourceFunction.getPosition(), errorMessage);
        }
    }
}

