/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.consumer;

import io.nats.client.Message;
import io.nats.client.MessageHandler;
import java.util.Arrays;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.nats.Utils;

public class DefaultMessageHandler
implements MessageHandler {
    private ObjectValue serviceObject;
    private Scheduler scheduler;

    DefaultMessageHandler(Scheduler scheduler, ObjectValue serviceObject) {
        this.scheduler = scheduler;
        this.serviceObject = serviceObject;
    }

    public void onMessage(Message message) {
        ArrayValue msgData = new ArrayValue(message.getData());
        ObjectValue msgObj = BallerinaValues.createObjectValue((String)"ballerina/nats", (String)"Message", (Object[])new Object[]{message.getSubject(), msgData, message.getReplyTo()});
        AttachedFunction onMessage = Utils.getAttachedFunction(this.serviceObject, "onMessage");
        BType[] parameterTypes = onMessage.getParameterType();
        if (parameterTypes.length == 1) {
            Executor.submit((Scheduler)this.scheduler, (ObjectValue)this.serviceObject, (String)"onMessage", (CallableUnitCallback)new ResponseCallback(), null, (Object[])new Object[]{msgObj, Boolean.TRUE});
        } else {
            BType intendedTypeForData = parameterTypes[1];
            this.dispatch(msgObj, intendedTypeForData, message.getData());
        }
    }

    private void dispatch(ObjectValue msgObj, BType intendedType, byte[] data) {
        block4: {
            AttachedFunction[] attachedFunctions = this.serviceObject.getType().getAttachedFunctions();
            boolean onErrorResourcePresent = Arrays.stream(attachedFunctions).anyMatch(resource -> resource.getName().equals("onError"));
            try {
                Object typeBoundData = Utils.bindDataToIntendedType(data, intendedType);
                Executor.submit((Scheduler)this.scheduler, (ObjectValue)this.serviceObject, (String)"onMessage", (CallableUnitCallback)new ResponseCallback(), null, (Object[])new Object[]{msgObj, true, typeBoundData, true});
            }
            catch (NumberFormatException e) {
                if (onErrorResourcePresent) {
                    ErrorValue dataBindError = Utils.createNatsError("The received message is unsupported by the resource signature");
                    Executor.submit((Scheduler)this.scheduler, (ObjectValue)this.serviceObject, (String)"onError", (CallableUnitCallback)new ResponseCallback(), null, (Object[])new Object[]{msgObj, true, dataBindError, true});
                }
            }
            catch (ErrorValue e) {
                if (!onErrorResourcePresent) break block4;
                Executor.submit((Scheduler)this.scheduler, (ObjectValue)this.serviceObject, (String)"onError", (CallableUnitCallback)new ResponseCallback(), null, (Object[])new Object[]{msgObj, true, e, true});
            }
        }
    }

    public static class ResponseCallback
    implements CallableUnitCallback {
        public void notifySuccess() {
        }

        public void notifyFailure(ErrorValue error) {
            ErrorHandlerUtils.printError((Throwable)error);
        }
    }
}

