/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.consumer;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.MessageHandler;
import java.io.PrintStream;
import java.util.List;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.nats.basic.consumer.DefaultMessageHandler;

@BallerinaFunction(orgName="ballerina", packageName="nats", functionName="register", receiver=@Receiver(type=TypeKind.OBJECT, structType="Listener", structPackage="ballerina/nats"), isPublic=true)
public class Register {
    private static final PrintStream console = System.out;

    public static Object register(Strand strand, ObjectValue listenerObject, ObjectValue service, Object annotationData) {
        Connection natsConnection = (Connection)((ObjectValue)listenerObject.get("connection")).getNativeData("nats_connection");
        List serviceList = (List)((ObjectValue)listenerObject.get("connection")).getNativeData("service_list");
        MapValue<String, Object> subscriptionConfig = Register.getSubscriptionConfig(service.getType().getAnnotation("ballerina/nats", "SubscriptionConfig"));
        if (subscriptionConfig == null) {
            return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)"Error while registering the subscriber. Cannot find subscription configuration");
        }
        String queueName = subscriptionConfig.getStringValue("queueName");
        String subject = subscriptionConfig.getStringValue("subject");
        Dispatcher dispatcher = natsConnection.createDispatcher((MessageHandler)new DefaultMessageHandler(strand.scheduler, service));
        List dispatcherList = (List)listenerObject.getNativeData("dispatcher_list");
        dispatcherList.add(dispatcher);
        try {
            if (queueName != null) {
                dispatcher.subscribe(subject, queueName);
            } else {
                dispatcher.subscribe(subject);
            }
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while registering the subscriber. " + ex.getMessage()));
        }
        serviceList.add(service);
        String sOutput = "subject " + subject + (queueName != null ? " & queue " + queueName : "");
        console.println("[ballerina/nats] Client subscribed for " + sOutput);
        return null;
    }

    private static MapValue<String, Object> getSubscriptionConfig(Object annotationData) {
        MapValue annotationRecord = null;
        if (TypeChecker.getType((Object)annotationData).getTag() == 12) {
            annotationRecord = (MapValue)annotationData;
        }
        return annotationRecord;
    }
}

