/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.consumer;

import io.nats.client.Connection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.nats.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="nats", functionName="stop", receiver=@Receiver(type=TypeKind.OBJECT, structType="Listener", structPackage="ballerina/nats"), isPublic=true)
public class Stop {
    private static final Logger LOG = LoggerFactory.getLogger(Stop.class);

    public static void stop(Strand strand, ObjectValue listenerObject) {
        ObjectValue connectionObject = (ObjectValue)listenerObject.get("connection");
        if (connectionObject == null) {
            LOG.debug("Connection object reference not exists. Possibly connection already closed.");
            return;
        }
        Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
        if (natsConnection == null) {
            LOG.debug("NATS connection not exists. Possibly connection already closed.");
            listenerObject.set("connection", null);
            return;
        }
        List dispatcherList = (List)listenerObject.getNativeData("dispatcher_list");
        dispatcherList.forEach(arg_0 -> ((Connection)natsConnection).closeDispatcher(arg_0));
        int clientsCount = ((AtomicInteger)connectionObject.getNativeData("connected_clients")).decrementAndGet();
        if (clientsCount == 0) {
            try {
                natsConnection.close();
            }
            catch (InterruptedException e) {
                throw Utils.createNatsError("Listener interrupted while closing NATS connection");
            }
        }
    }
}

