/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.producer;

import io.nats.client.Connection;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.nats.Utils;

@BallerinaFunction(orgName="ballerina", packageName="nats", functionName="externPublish", receiver=@Receiver(type=TypeKind.OBJECT, structType="Producer", structPackage="ballerina/nats"), isPublic=true)
public class Publish {
    public static Object externPublish(Strand strand, ObjectValue producerObject, String subject, Object data, Object replyTo) {
        Object connection = producerObject.get("connection");
        if (TypeChecker.getType((Object)connection).getTag() == 35) {
            ObjectValue connectionObject = (ObjectValue)connection;
            Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
            if (natsConnection == null) {
                return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while publishing message to subject " + subject + ". NATS connection doesn't exist."));
            }
            byte[] byteContent = Utils.convertDataIntoByteArray(data);
            try {
                if (TypeChecker.getType((Object)replyTo).getTag() == 5) {
                    natsConnection.publish(subject, (String)replyTo, byteContent);
                }
                natsConnection.publish(subject, byteContent);
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while publishing message to subject " + subject + ". " + ex.getMessage()));
            }
        } else {
            return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while publishing message to subject " + subject + ". Producer is logically disconnected."));
        }
        return null;
    }
}

