/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.producer;

import io.nats.client.Connection;
import io.nats.client.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.nats.Utils;

@BallerinaFunction(orgName="ballerina", packageName="nats", functionName="externRequest", receiver=@Receiver(type=TypeKind.OBJECT, structType="Producer", structPackage="ballerina/nats"), isPublic=true)
public class Request {
    public static Object externRequest(Strand strand, ObjectValue producerObject, String subject, Object data, Object duration) {
        Object connection = producerObject.get("connection");
        if (TypeChecker.getType((Object)connection).getTag() == 35) {
            ObjectValue connectionObject = (ObjectValue)connection;
            Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
            if (natsConnection == null) {
                return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while publishing message to subject " + subject + ". NATS connection doesn't exist."));
            }
            byte[] byteContent = Utils.convertDataIntoByteArray(data);
            try {
                CompletableFuture incoming = natsConnection.request(subject, byteContent);
                Message reply = TypeChecker.getType((Object)duration).getTag() == 1 ? (Message)incoming.get((Long)duration, TimeUnit.MILLISECONDS) : (Message)incoming.get();
                ArrayValue msgData = new ArrayValue(reply.getData());
                ObjectValue msgObj = BallerinaValues.createObjectValue((String)"ballerina/nats", (String)"Message", (Object[])new Object[]{reply.getSubject(), msgData, reply.getReplyTo()});
                msgObj.addNativeData("NATSMSG", (Object)reply);
                return msgObj;
            }
            catch (IllegalArgumentException | IllegalStateException | InterruptedException | ExecutionException | TimeoutException ex) {
                return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while requesting message to subject " + subject + ". " + ex.getMessage()));
            }
        }
        return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while publishing message to subject " + subject + ". Producer is logically disconnected."));
    }
}

