/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.connection;

import io.nats.client.Connection;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="nats", functionName="close", receiver=@Receiver(type=TypeKind.OBJECT, structType="Connection", structPackage="ballerina/nats"), isPublic=true)
public class Close {
    private static final Logger LOG = LoggerFactory.getLogger(Close.class);
    private static PrintStream console = System.out;

    public static Object close(Strand strand, ObjectValue connectionObject, Object forceful) {
        int clientCount = ((AtomicInteger)connectionObject.getNativeData("connected_clients")).get();
        if (clientCount == 0 || Close.isForceShutdown(forceful)) {
            Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
            try {
                if (natsConnection != null) {
                    natsConnection.close();
                }
                connectionObject.addNativeData("nats_connection", null);
                connectionObject.addNativeData("connected_clients", null);
                return null;
            }
            catch (InterruptedException e) {
                return BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)("Error while closing the connection with nats server. " + e.getMessage()));
            }
        }
        String message = "Connection is still used by " + clientCount + " client(s). Close them before closing the connection.";
        LOG.warn(message);
        console.println(message);
        connectionObject.addNativeData("closing", (Object)true);
        return null;
    }

    private static boolean isForceShutdown(Object forceful) {
        return TypeChecker.getType((Object)forceful).getTag() == 6 && (Boolean)forceful != false;
    }
}

