/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.connection;

import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.basic.consumer.DefaultMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionListener
implements ConnectionListener {
    private static final PrintStream console;
    private static final Logger LOG;
    private final Scheduler scheduler;
    private final List<ObjectValue> serviceList;

    DefaultConnectionListener(Scheduler scheduler, List<ObjectValue> serviceList) {
        this.scheduler = scheduler;
        this.serviceList = serviceList;
    }

    public void connectionEvent(Connection conn, ConnectionListener.Events type) {
        switch (type) {
            case CONNECTED: {
                console.println("[ballerina/nats] Connection established with server " + conn.getConnectedUrl());
                break;
            }
            case CLOSED: {
                String message = conn.getLastError() != null ? "Connection closed." + conn.getLastError() : "Connection closed.";
                ErrorValue errorValue = BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)message);
                LOG.warn(message);
                for (ObjectValue service : this.serviceList) {
                    boolean onErrorResourcePresent = Arrays.stream(service.getType().getAttachedFunctions()).anyMatch(resource -> resource.getName().equals("onError"));
                    if (!onErrorResourcePresent) continue;
                    Executor.submit((Scheduler)this.scheduler, (ObjectValue)service, (String)"onError", (CallableUnitCallback)new DefaultMessageHandler.ResponseCallback(), null, (Object[])new Object[]{Utils.getMessageObject(null), Boolean.TRUE, errorValue, Boolean.TRUE});
                }
                break;
            }
            case RECONNECTED: {
                LOG.debug("Connection reconnected with server " + conn.getConnectedUrl());
                break;
            }
            case DISCONNECTED: {
                LOG.debug("Connection disconnected with server " + conn.getConnectedUrl());
                break;
            }
            case RESUBSCRIBED: {
                LOG.debug("Subscriptions reestablished with server " + conn.getConnectedUrl());
                break;
            }
            case DISCOVERED_SERVERS: {
                LOG.debug("Server discovered. List of connected servers " + Arrays.toString(conn.getServers().toArray()));
            }
        }
    }

    static {
        LOG = LoggerFactory.getLogger(DefaultConnectionListener.class);
        console = System.out;
    }
}

