/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.connection;

import io.nats.client.Connection;
import io.nats.client.Consumer;
import io.nats.client.ErrorListener;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.basic.consumer.DefaultMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorListener
implements ErrorListener {
    private static final PrintStream console;
    private static final Logger LOG;
    private final Scheduler scheduler;
    private final List<ObjectValue> serviceList;

    DefaultErrorListener(Scheduler scheduler, List<ObjectValue> serviceList) {
        this.scheduler = scheduler;
        this.serviceList = serviceList;
    }

    public void errorOccurred(Connection conn, String error) {
        String message = "Error in server " + conn.getConnectedUrl() + ". " + error;
        ErrorValue errorValue = BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)message);
        LOG.error(message);
        for (ObjectValue service : this.serviceList) {
            boolean onErrorResourcePresent = Arrays.stream(service.getType().getAttachedFunctions()).anyMatch(resource -> resource.getName().equals("onError"));
            if (!onErrorResourcePresent) continue;
            Executor.submit((Scheduler)this.scheduler, (ObjectValue)service, (String)"onError", (CallableUnitCallback)new DefaultMessageHandler.ResponseCallback(), null, (Object[])new Object[]{Utils.getMessageObject(null), Boolean.TRUE, errorValue, Boolean.TRUE});
        }
    }

    public void exceptionOccurred(Connection conn, Exception exp) {
        LOG.error("Exception in server " + conn.getConnectedUrl(), (Throwable)exp);
        String errorMsg = exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage();
        ErrorValue errorValue = BallerinaErrors.createError((String)"{ballerina/nats}Error", (String)errorMsg);
        for (ObjectValue service : this.serviceList) {
            boolean onErrorResourcePresent = Arrays.stream(service.getType().getAttachedFunctions()).anyMatch(resource -> resource.getName().equals("onError"));
            if (!onErrorResourcePresent) continue;
            Executor.submit((Scheduler)this.scheduler, (ObjectValue)service, (String)"onError", (CallableUnitCallback)new DefaultMessageHandler.ResponseCallback(), null, (Object[])new Object[]{Utils.getMessageObject(null), Boolean.TRUE, errorValue, Boolean.TRUE});
        }
    }

    public void slowConsumerDetected(Connection conn, Consumer consumer) {
        LOG.error("slow consumer detected in server " + conn.getConnectedUrl() + " | " + consumer.toString());
    }

    static {
        LOG = LoggerFactory.getLogger(DefaultErrorListener.class);
        console = System.out;
    }
}

