/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.connection;

import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.client.Nats;
import io.nats.client.Options;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.connection.DefaultConnectionListener;
import org.ballerinalang.nats.connection.DefaultErrorListener;

@BallerinaFunction(orgName="ballerina", packageName="nats", functionName="init", receiver=@Receiver(type=TypeKind.OBJECT, structType="Connection", structPackage="ballerina/nats"), isPublic=true)
public class Init {
    private static final String RECONNECT_WAIT = "reconnectWaitInSeconds";
    private static final String SERVER_URL_SEPARATOR = ",";
    private static final String CONNECTION_NAME = "connectionName";
    private static final String MAX_RECONNECT = "maxReconnect";
    private static final String CONNECTION_TIMEOUT = "connectionTimeoutInSeconds";
    private static final String PING_INTERVAL = "pingIntervalInMinutes";
    private static final String MAX_PINGS_OUT = "maxPingsOut";
    private static final String INBOX_PREFIX = "inboxPrefix";
    private static final String NO_ECHO = "noEcho";
    private static final String ENABLE_ERROR_LISTENER = "enableErrorListener";

    public static void init(Strand strand, ObjectValue connectionObject, String urlString, MapValue connectionConfig) {
        MapValue secureSocket;
        Options.Builder opts = new Options.Builder();
        String[] serverUrls = urlString != null && urlString.contains(SERVER_URL_SEPARATOR) ? urlString.split(SERVER_URL_SEPARATOR) : new String[]{urlString};
        opts.servers(serverUrls);
        opts.connectionName(connectionConfig.getStringValue(CONNECTION_NAME));
        opts.maxReconnects(Math.toIntExact(connectionConfig.getIntValue(MAX_RECONNECT)));
        opts.reconnectWait(Duration.ofSeconds(connectionConfig.getIntValue(RECONNECT_WAIT)));
        opts.connectionTimeout(Duration.ofSeconds(connectionConfig.getIntValue(CONNECTION_TIMEOUT)));
        opts.pingInterval(Duration.ofMinutes(connectionConfig.getIntValue(PING_INTERVAL)));
        opts.maxPingsOut(Math.toIntExact(connectionConfig.getIntValue(MAX_PINGS_OUT)));
        opts.inboxPrefix(connectionConfig.getStringValue(INBOX_PREFIX));
        List<ObjectValue> serviceList = Collections.synchronizedList(new ArrayList());
        opts.connectionListener((ConnectionListener)new DefaultConnectionListener(strand.scheduler, serviceList));
        if (connectionConfig.getBooleanValue(ENABLE_ERROR_LISTENER).booleanValue()) {
            DefaultErrorListener errorListener = new DefaultErrorListener(strand.scheduler, serviceList);
            opts.errorListener((ErrorListener)errorListener);
        }
        if (connectionConfig.getBooleanValue(NO_ECHO).booleanValue()) {
            opts.noEcho();
        }
        if ((secureSocket = connectionConfig.getMapValue("secureSocket")) != null) {
            SSLContext sslContext = Init.getSSLContext(secureSocket);
            opts.sslContext(sslContext);
        }
        try {
            Connection natsConnection = Nats.connect((Options)opts.build());
            connectionObject.addNativeData("nats_connection", (Object)natsConnection);
            connectionObject.addNativeData("connected_clients", (Object)new AtomicInteger(0));
            connectionObject.addNativeData("service_list", serviceList);
        }
        catch (IOException | InterruptedException e) {
            String errorMsg = "Error while setting up a connection. " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
            throw Utils.createNatsError(errorMsg);
        }
    }

    private static SSLContext getSSLContext(MapValue secureSocket) {
        try {
            MapValue cryptoKeyStore = secureSocket.getMapValue("keyStore");
            KeyManagerFactory keyManagerFactory = null;
            if (cryptoKeyStore != null) {
                char[] keyPassphrase = cryptoKeyStore.getStringValue("password").toCharArray();
                String keyFilePath = cryptoKeyStore.getStringValue("path");
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                if (keyFilePath != null) {
                    try (FileInputStream keyFileInputStream = new FileInputStream(keyFilePath);){
                        keyStore.load(keyFileInputStream, keyPassphrase);
                    }
                } else {
                    throw Utils.createNatsError("Error while setting up secured connection. Keystore path doesn't exist.");
                }
                keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, keyPassphrase);
            }
            MapValue cryptoTrustStore = secureSocket.getMapValue("trustStore");
            TrustManagerFactory trustManagerFactory = null;
            if (cryptoTrustStore != null) {
                KeyStore trustStore = KeyStore.getInstance("PKCS12");
                char[] trustPassphrase = cryptoTrustStore.getStringValue("password").toCharArray();
                String trustFilePath = cryptoTrustStore.getStringValue("path");
                if (trustFilePath != null) {
                    try (FileInputStream trustFileInputStream = new FileInputStream(trustFilePath);){
                        trustStore.load(trustFileInputStream, trustPassphrase);
                    }
                } else {
                    throw Utils.createNatsError("Error while setting up secured connection. Truststore path doesn't exist.");
                }
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
            }
            String tlsVersion = secureSocket.getStringValue("protocol");
            SSLContext sslContext = SSLContext.getInstance(tlsVersion);
            sslContext.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null, null);
            return sslContext;
        }
        catch (FileNotFoundException e) {
            throw Utils.createNatsError("Error while setting up secured connection. File not found error, " + e.getMessage());
        }
        catch (CertificateException e) {
            throw Utils.createNatsError("Error while setting up secured connection. Certificate error, " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw Utils.createNatsError("Error while setting up secured connection. Algorithm error, " + e.getMessage());
        }
        catch (IOException e) {
            throw Utils.createNatsError("Error while setting up secured connection. IO error, " + e.getMessage());
        }
        catch (KeyStoreException e) {
            throw Utils.createNatsError("Error while setting up secured connection. Keystore error, " + e.getMessage());
        }
        catch (UnrecoverableKeyException e) {
            throw Utils.createNatsError("Error while setting up secured connection. The key in the keystore cannot be recovered.");
        }
        catch (KeyManagementException e) {
            throw Utils.createNatsError("Error while setting up secured connection. Key management error, " + e.getMessage());
        }
    }
}

