/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.streaming;

import io.nats.client.Connection;
import io.nats.streaming.StreamingConnection;
import io.nats.streaming.StreamingConnectionFactory;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.jvm.values.MapValue;

public class BallerinaNatsStreamingConnectionFactory {
    private final MapValue<String, Object> streamingConfig;
    private final Connection natsConnection;
    private final String clusterId;
    private final String clientId;
    private static final String ACK_TIMEOUT = "ackTimeoutInSeconds";
    private static final String CONNECTION_TIMEOUT = "connectionTimeoutInSeconds";
    private static final String MAX_PUB_ACKS_IN_FLIGHT = "maxPubAcksInFlight";
    private static final String DISCOVERY_PREFIX = "discoverPrefix";

    public BallerinaNatsStreamingConnectionFactory(Connection natsConnection, String clusterId, String clientId, MapValue<String, Object> streamingConfig) {
        this.streamingConfig = streamingConfig;
        this.natsConnection = natsConnection;
        this.clusterId = clusterId;
        this.clientId = clientId;
    }

    public StreamingConnection createConnection() throws IOException, InterruptedException {
        StreamingConnectionFactory streamingConnectionFactory = new StreamingConnectionFactory(this.clusterId, this.clientId);
        streamingConnectionFactory.setNatsConnection(this.natsConnection);
        if (this.streamingConfig != null) {
            streamingConnectionFactory.setAckTimeout(this.streamingConfig.getIntValue(ACK_TIMEOUT).longValue(), TimeUnit.SECONDS);
            streamingConnectionFactory.setConnectTimeout(this.streamingConfig.getIntValue(CONNECTION_TIMEOUT).longValue(), TimeUnit.SECONDS);
            streamingConnectionFactory.setMaxPubAcksInFlight(this.streamingConfig.getIntValue(MAX_PUB_ACKS_IN_FLIGHT).intValue());
            streamingConnectionFactory.setDiscoverPrefix(this.streamingConfig.getStringValue(DISCOVERY_PREFIX));
        }
        return streamingConnectionFactory.createConnection();
    }
}

