/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.streaming.producer;

import io.nats.streaming.StreamingConnection;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.nats.Utils;

@BallerinaFunction(orgName="ballerina", packageName="nats", functionName="detachFromNatsConnection", isPublic=true)
public class CloseConnection {
    public static Object detachFromNatsConnection(Strand strand, Object streamingClient, Object natsConnection) {
        ObjectValue streamingClientObject = (ObjectValue)streamingClient;
        StreamingConnection streamingConnection = (StreamingConnection)streamingClientObject.getNativeData("nats_streaming_connection");
        try {
            streamingConnection.close();
            ObjectValue basicNatsConnection = (ObjectValue)natsConnection;
            ((AtomicInteger)basicNatsConnection.getNativeData("connected_clients")).decrementAndGet();
            return null;
        }
        catch (IOException | TimeoutException e) {
            return Utils.createNatsError(e.getMessage());
        }
        catch (InterruptedException e) {
            return Utils.createNatsError("Internal error while closing producer");
        }
    }
}

