/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.streaming.producer;

import io.nats.client.Connection;
import io.nats.streaming.StreamingConnection;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.streaming.BallerinaNatsStreamingConnectionFactory;

@BallerinaFunction(orgName="ballerina", packageName="nats", functionName="createStreamingConnection", isPublic=true)
public class CreateStreamingConnection {
    public static void createStreamingConnection(Strand strand, Object streamingClient, Object conn, String clusterId, Object clientIdNillable, Object streamingConfig) {
        ObjectValue connectionObject = (ObjectValue)conn;
        Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
        String clientId = clientIdNillable == null ? UUID.randomUUID().toString() : (String)clientIdNillable;
        BallerinaNatsStreamingConnectionFactory streamingConnectionFactory = new BallerinaNatsStreamingConnectionFactory(natsConnection, clusterId, clientId, (MapValue<String, Object>)((MapValue)streamingConfig));
        try {
            StreamingConnection streamingConnection = streamingConnectionFactory.createConnection();
            ((ObjectValue)streamingClient).addNativeData("nats_streaming_connection", (Object)streamingConnection);
            ((AtomicInteger)connectionObject.getNativeData("connected_clients")).incrementAndGet();
        }
        catch (IOException e) {
            throw Utils.createNatsError(e.getMessage());
        }
        catch (InterruptedException e) {
            throw Utils.createNatsError("Internal error while creating streaming connection");
        }
    }
}

