/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.streaming.producer;

import io.nats.streaming.AckHandler;
import io.nats.streaming.StreamingConnection;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.streaming.producer.AckListener;

@BallerinaFunction(orgName="ballerina", packageName="nats", functionName="externPublish", receiver=@Receiver(type=TypeKind.OBJECT, structType="StreamingProducer", structPackage="ballerina/nats"), isPublic=true)
public class Publish {
    public static Object externPublish(Strand strand, ObjectValue publisher, String subject, Object data) {
        StreamingConnection streamingConnection = (StreamingConnection)publisher.getNativeData("nats_streaming_connection");
        byte[] byteData = Utils.convertDataIntoByteArray(data);
        try {
            NonBlockingCallback nonBlockingCallback = new NonBlockingCallback(strand);
            AckListener ackListener = new AckListener(nonBlockingCallback);
            streamingConnection.publish(subject, byteData, (AckHandler)ackListener);
            return null;
        }
        catch (InterruptedException e) {
            return Utils.createNatsError("Failed to publish due to an internal error");
        }
        catch (IOException | TimeoutException e) {
            return Utils.createNatsError(e.getMessage());
        }
    }
}

