/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.consumer;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.nats.Constants;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsReporter;
import org.ballerinalang.nats.observability.NatsTracingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmediateStop {
    private static final Logger LOG = LoggerFactory.getLogger(ImmediateStop.class);

    public static void basicImmediateStop(ObjectValue listenerObject) {
        NatsTracingUtil.traceResourceInvocation(Scheduler.getStrand(), listenerObject);
        ObjectValue connectionObject = (ObjectValue)listenerObject.get(Constants.CONNECTION_OBJ);
        if (connectionObject == null) {
            NatsMetricsReporter.reportConsumerError("close");
            LOG.debug("Connection object reference does not exist. Possibly the connection is already closed.");
            return;
        }
        Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
        NatsMetricsReporter natsMetricsReporter = (NatsMetricsReporter)connectionObject.getNativeData("nats_metric_util");
        if (natsConnection == null) {
            NatsMetricsReporter.reportConsumerError("close");
            LOG.debug("NATS connection does not exist. Possibly the connection is already closed.");
            return;
        }
        ConcurrentHashMap dispatcherList = (ConcurrentHashMap)listenerObject.getNativeData("dispatcher_list");
        Iterator dispatchers = dispatcherList.entrySet().iterator();
        while (dispatchers.hasNext()) {
            Map.Entry pair = dispatchers.next();
            natsConnection.closeDispatcher((Dispatcher)pair.getValue());
            dispatchers.remove();
        }
        ArrayList subscriptionsList = (ArrayList)listenerObject.getNativeData("BasicSubscriptionList");
        natsMetricsReporter.reportBulkUnsubscription(subscriptionsList);
        int clientsCount = ((AtomicInteger)connectionObject.getNativeData("connected_clients")).decrementAndGet();
        if (clientsCount == 0) {
            try {
                natsConnection.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                natsMetricsReporter.reportConsumerError("unknown", "close");
                throw Utils.createNatsError("Listener interrupted while closing NATS connection");
            }
        }
    }
}

