/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.producer;

import io.nats.client.Connection;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.nats.Constants;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsReporter;
import org.ballerinalang.nats.observability.NatsTracingUtil;

public class Publish {
    public static Object externPublish(ObjectValue producerObject, BString subject, Object data, Object replyTo) {
        NatsTracingUtil.traceResourceInvocation(Scheduler.getStrand(), producerObject, subject.getValue());
        Object connection = producerObject.get(Constants.CONNECTION_OBJ);
        if (TypeChecker.getType((Object)connection).getTag() == 35) {
            ObjectValue connectionObject = (ObjectValue)connection;
            Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
            NatsMetricsReporter natsMetricsReporter = (NatsMetricsReporter)connectionObject.getNativeData("nats_metric_util");
            if (natsConnection == null) {
                natsMetricsReporter.reportProducerError(subject.getValue(), "publish");
                return Utils.createNatsError("Error while publishing message to subject " + subject.getValue() + ". NATS connection doesn't exist.");
            }
            byte[] byteContent = Utils.convertDataIntoByteArray(data);
            try {
                if (TypeChecker.getType((Object)replyTo).getTag() == 5) {
                    natsConnection.publish(subject.getValue(), ((BString)replyTo).getValue(), byteContent);
                } else if (TypeChecker.getType((Object)replyTo).getTag() == 19) {
                    MapValue<BString, Object> subscriptionConfig = Publish.getSubscriptionConfig(((ObjectValue)replyTo).getType().getAnnotation("ballerina/nats:1.0.0", "SubscriptionConfig"));
                    if (subscriptionConfig == null) {
                        natsMetricsReporter.reportProducerError(subject.getValue(), "publish");
                        return Utils.createNatsError("Cannot find subscription configuration");
                    }
                    String replyToSubject = subscriptionConfig.getStringValue(Constants.SUBJECT).getValue();
                    natsConnection.publish(subject.getValue(), replyToSubject, byteContent);
                } else {
                    natsConnection.publish(subject.getValue(), byteContent);
                }
                natsMetricsReporter.reportPublish(subject.getValue(), byteContent.length);
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                natsMetricsReporter.reportProducerError(subject.getValue(), "publish");
                return Utils.createNatsError("Error while publishing message to subject " + subject.getValue() + ". " + ex.getMessage());
            }
        } else {
            NatsMetricsReporter.reportProducerError("publish");
            return Utils.createNatsError("Error while publishing message to subject " + subject.getValue() + ". Producer is logically disconnected.");
        }
        return null;
    }

    private static MapValue<BString, Object> getSubscriptionConfig(Object annotationData) {
        MapValue annotationRecord = null;
        if (TypeChecker.getType((Object)annotationData).getTag() == 12) {
            annotationRecord = (MapValue)annotationData;
        }
        return annotationRecord;
    }
}

