/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.basic.producer;

import io.nats.client.Connection;
import io.nats.client.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.nats.Constants;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsReporter;
import org.ballerinalang.nats.observability.NatsTracingUtil;

public class Request {
    public static Object externRequest(ObjectValue producerObject, BString subject, Object data, Object duration) {
        NatsTracingUtil.traceResourceInvocation(Scheduler.getStrand(), producerObject, subject.getValue());
        Object connection = producerObject.get(Constants.CONNECTION_OBJ);
        if (TypeChecker.getType((Object)connection).getTag() == 35) {
            ObjectValue connectionObject = (ObjectValue)connection;
            Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
            if (natsConnection == null) {
                NatsMetricsReporter.reportProducerError("request");
                return Utils.createNatsError("Error while publishing message to subject " + subject.getValue() + ". NATS connection doesn't exist.");
            }
            NatsMetricsReporter natsMetricsReporter = (NatsMetricsReporter)connectionObject.getNativeData("nats_metric_util");
            byte[] byteContent = Utils.convertDataIntoByteArray(data);
            try {
                CompletableFuture incoming = natsConnection.request(subject.getValue(), byteContent);
                natsMetricsReporter.reportRequest(subject.getValue(), byteContent.length);
                Message reply = TypeChecker.getType((Object)duration).getTag() == 1 ? (Message)incoming.get((Long)duration, TimeUnit.MILLISECONDS) : (Message)incoming.get();
                ArrayValueImpl msgData = new ArrayValueImpl(reply.getData());
                natsMetricsReporter.reportResponse(subject.getValue());
                ObjectValue msgObj = BallerinaValues.createObjectValue((BPackage)Constants.NATS_PACKAGE_ID, (String)"Message", (Object[])new Object[]{reply.getSubject(), msgData, reply.getReplyTo()});
                msgObj.addNativeData("NATSMSG", (Object)reply);
                return msgObj;
            }
            catch (TimeoutException ex) {
                natsMetricsReporter.reportProducerError(subject.getValue(), "request");
                return Utils.createNatsError("Request to subject " + subject.getValue() + " timed out while waiting for a reply");
            }
            catch (IllegalArgumentException | IllegalStateException | ExecutionException ex) {
                natsMetricsReporter.reportProducerError(subject.getValue(), "request");
                return Utils.createNatsError("Error while requesting message to subject " + subject.getValue() + ". " + ex.getMessage());
            }
            catch (InterruptedException ex) {
                natsMetricsReporter.reportProducerError(subject.getValue(), "request");
                Thread.currentThread().interrupt();
                return Utils.createNatsError("Error while requesting message to subject " + subject.getValue() + ". " + ex.getMessage());
            }
        }
        NatsMetricsReporter.reportProducerError("request");
        return Utils.createNatsError("Error while publishing message to subject " + subject.getValue() + ". Producer is logically disconnected.");
    }
}

