/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.connection;

import io.nats.client.Connection;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.nats.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Close {
    private static final Logger LOG = LoggerFactory.getLogger(Close.class);
    private static PrintStream console = System.out;

    public static Object externClose(ObjectValue connectionObject, boolean forceful) {
        int clientCount = ((AtomicInteger)connectionObject.getNativeData("connected_clients")).get();
        if (clientCount == 0 || forceful) {
            Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
            try {
                if (natsConnection != null) {
                    natsConnection.close();
                }
                connectionObject.addNativeData("nats_connection", null);
                connectionObject.addNativeData("connected_clients", null);
                return null;
            }
            catch (InterruptedException e) {
                return Utils.createNatsError("Error while closing the connection with nats server. " + e.getMessage());
            }
        }
        String message = "Connection is still used by " + clientCount + " client(s). Close them before closing the connection.";
        LOG.warn(message);
        console.println(message);
        connectionObject.addNativeData("closing", (Object)true);
        return null;
    }
}

