/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.connection;

import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import java.io.PrintStream;
import java.util.Arrays;
import org.ballerinalang.nats.observability.NatsMetricsReporter;

public class DefaultConnectionListener
implements ConnectionListener {
    private static final PrintStream console = System.out;
    private boolean printDisconnected = true;

    DefaultConnectionListener() {
    }

    public void connectionEvent(Connection conn, ConnectionListener.Events type) {
        String url = conn.getConnectedUrl();
        switch (type) {
            case CONNECTED: {
                this.printToConsole("Connection established with server " + url);
                NatsMetricsReporter.reportNewConnection(url);
                break;
            }
            case CLOSED: {
                this.printToConsole(conn.getLastError() != null ? "Connection closed." + conn.getLastError() : "Connection closed.");
                NatsMetricsReporter.reportConnectionClose(url);
                break;
            }
            case RECONNECTED: {
                this.printToConsole("Connection reconnected with server " + conn.getConnectedUrl());
                this.printDisconnected = true;
                NatsMetricsReporter.reportNewConnection(url);
                break;
            }
            case DISCONNECTED: {
                if (!this.printDisconnected) break;
                this.printToConsole("Connection disconnected with server " + conn.getLastError());
                this.printDisconnected = false;
                NatsMetricsReporter.reportConnectionClose(url);
                break;
            }
            case RESUBSCRIBED: {
                this.printToConsole("Subscriptions re-established with server " + conn.getConnectedUrl());
                break;
            }
            case DISCOVERED_SERVERS: {
                this.printToConsole("Server discovered. List of connected servers " + Arrays.toString(conn.getServers().toArray()));
            }
        }
    }

    private void printToConsole(String message) {
        console.println("[ballerina/nats] " + message);
    }
}

