/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.connection;

import io.nats.client.Connection;
import io.nats.streaming.StreamingConnection;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsReporter;
import org.ballerinalang.nats.observability.NatsTracingUtil;
import org.ballerinalang.nats.streaming.BallerinaNatsStreamingConnectionFactory;

public class NatsStreamingConnection {
    public static void createConnection(ObjectValue streamingClientObject, ObjectValue connectionObject, String clusterId, Object clientIdNillable, Object streamingConfig) {
        Connection natsConnection = (Connection)connectionObject.getNativeData("nats_connection");
        String clientId = clientIdNillable == null ? UUID.randomUUID().toString() : ((BString)clientIdNillable).getValue();
        BallerinaNatsStreamingConnectionFactory streamingConnectionFactory = new BallerinaNatsStreamingConnectionFactory(natsConnection, clusterId, clientId, (MapValue<BString, Object>)((MapValue)streamingConfig));
        try {
            StreamingConnection streamingConnection = streamingConnectionFactory.createConnection();
            streamingClientObject.addNativeData("nats_streaming_connection", (Object)streamingConnection);
            ((AtomicInteger)connectionObject.getNativeData("connected_clients")).incrementAndGet();
        }
        catch (IOException e) {
            NatsMetricsReporter.reportError("streaming_connection", "connection");
            throw Utils.createNatsError(e.getMessage());
        }
        catch (InterruptedException e) {
            NatsMetricsReporter.reportError("streaming_connection", "connection");
            throw Utils.createNatsError("Internal error while creating streaming connection");
        }
    }

    public static Object closeConnection(ObjectValue streamingClientObject, ObjectValue natsConnection) {
        StreamingConnection streamingConnection = (StreamingConnection)streamingClientObject.getNativeData("nats_streaming_connection");
        NatsTracingUtil.traceResourceInvocation(Scheduler.getStrand(), streamingConnection.getNatsConnection().getConnectedUrl());
        try {
            streamingConnection.close();
            ((AtomicInteger)natsConnection.getNativeData("connected_clients")).decrementAndGet();
            return null;
        }
        catch (IOException | TimeoutException e) {
            NatsMetricsReporter.reportStremingError(streamingConnection.getNatsConnection().getConnectedUrl(), "unknown", "streaming_connection", "close");
            return Utils.createNatsError(e.getMessage());
        }
        catch (InterruptedException e) {
            NatsMetricsReporter.reportStremingError(streamingConnection.getNatsConnection().getConnectedUrl(), "unknown", "streaming_connection", "close");
            return Utils.createNatsError("Internal error while closing producer");
        }
    }
}

