/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.observability;

import io.nats.client.Connection;
import java.util.ArrayList;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.metrics.DefaultMetricRegistry;
import org.ballerinalang.jvm.observability.metrics.MetricId;
import org.ballerinalang.jvm.observability.metrics.MetricRegistry;
import org.ballerinalang.jvm.observability.metrics.StatisticConfig;
import org.ballerinalang.nats.observability.NatsObservabilityConstants;
import org.ballerinalang.nats.observability.NatsObserverContext;

public class NatsMetricsReporter {
    private static final MetricRegistry metricRegistry = DefaultMetricRegistry.getInstance();
    private Connection connection;

    public NatsMetricsReporter(Connection connection) {
        this.connection = connection;
    }

    public static void reportNewConnection(String url) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.incrementGauge(new NatsObserverContext(url), NatsObservabilityConstants.METRIC_CONNECTIONS[0], NatsObservabilityConstants.METRIC_CONNECTIONS[1]);
    }

    public static void reportConnectionClose(String url) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.decrementGauge(new NatsObserverContext(url), NatsObservabilityConstants.METRIC_CONNECTIONS[0], NatsObservabilityConstants.METRIC_CONNECTIONS[1]);
    }

    public void reportNewProducer() {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.incrementGauge(new NatsObserverContext("producer", this.connection.getConnectedUrl()), NatsObservabilityConstants.METRIC_PUBLISHERS[0], NatsObservabilityConstants.METRIC_PUBLISHERS[1]);
    }

    public void reportProducerClose() {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.decrementGauge(new NatsObserverContext("producer", this.connection.getConnectedUrl()), NatsObservabilityConstants.METRIC_PUBLISHERS[0], NatsObservabilityConstants.METRIC_PUBLISHERS[1]);
    }

    public void reportPublish(String subject, int size) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.reportPublish(new NatsObserverContext("producer", this.connection.getConnectedUrl(), subject), size);
    }

    public void reportDelivery(String subject) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.incrementCounter(new NatsObserverContext("producer", this.connection.getConnectedUrl(), subject), NatsObservabilityConstants.METRIC_DELIVERED[0], NatsObservabilityConstants.METRIC_DELIVERED[1]);
    }

    public void reportRequest(String subject, int size) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsObserverContext observerContext = new NatsObserverContext("producer", this.connection.getConnectedUrl(), subject);
        NatsMetricsReporter.incrementCounter(observerContext, NatsObservabilityConstants.METRIC_REQUEST[0], NatsObservabilityConstants.METRIC_REQUEST[1]);
        NatsMetricsReporter.reportPublish(observerContext, size);
    }

    public void reportResponse(String subject) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.incrementCounter(new NatsObserverContext("producer", this.connection.getConnectedUrl(), subject), NatsObservabilityConstants.METRIC_RESPONSE[0], NatsObservabilityConstants.METRIC_RESPONSE[1]);
    }

    public static void reportSubscription(String url, String subject) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsObserverContext observerContext = new NatsObserverContext("producer", url, subject);
        NatsMetricsReporter.incrementGauge(observerContext, NatsObservabilityConstants.METRIC_SUBSCRIPTION[0], NatsObservabilityConstants.METRIC_SUBSCRIPTION[1]);
    }

    public void reportUnsubscription(String subject) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.decrementGauge(new NatsObserverContext("producer", this.connection.getConnectedUrl(), subject), NatsObservabilityConstants.METRIC_SUBSCRIPTION[0], NatsObservabilityConstants.METRIC_SUBSCRIPTION[1]);
    }

    public static void reportStreamingUnsubscription(String url, String subject) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.decrementGauge(new NatsObserverContext("producer", url, subject), NatsObservabilityConstants.METRIC_SUBSCRIPTION[0], NatsObservabilityConstants.METRIC_SUBSCRIPTION[1]);
    }

    public void reportBulkUnsubscription(ArrayList<String> subjects) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        for (String subject : subjects) {
            this.reportUnsubscription(subject);
        }
    }

    public void reportAcknowledgement(String subject) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.incrementCounter(new NatsObserverContext("producer", this.connection.getConnectedUrl(), subject), NatsObservabilityConstants.METRIC_ACK[0], NatsObservabilityConstants.METRIC_ACK[1]);
    }

    public void reportConsume(String subject, int size) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.reportConsume(new NatsObserverContext("consumer", this.connection.getConnectedUrl(), subject), size);
    }

    public static void reportProducerError(String errorType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.reportError("producer", errorType);
    }

    public void reportProducerError(String subject, String errorType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        this.reportError(subject, "producer", errorType);
    }

    public static void reportConsumerError(String errorType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        NatsMetricsReporter.reportError("consumer", errorType);
    }

    public void reportConsumerError(String subject, String errorType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        this.reportError(subject, "consumer", errorType);
    }

    private static void reportPublish(NatsObserverContext observerContext, int size) {
        NatsMetricsReporter.incrementCounter(observerContext, NatsObservabilityConstants.METRIC_PUBLISHED[0], NatsObservabilityConstants.METRIC_PUBLISHED[1]);
        NatsMetricsReporter.incrementCounter(observerContext, NatsObservabilityConstants.METRIC_PUBLISHED_SIZE[0], NatsObservabilityConstants.METRIC_PUBLISHED_SIZE[1], size);
    }

    private static void reportConsume(NatsObserverContext observerContext, int size) {
        NatsMetricsReporter.incrementCounter(observerContext, NatsObservabilityConstants.METRIC_CONSUMED[0], NatsObservabilityConstants.METRIC_CONSUMED[1]);
        NatsMetricsReporter.incrementCounter(observerContext, NatsObservabilityConstants.METRIC_CONSUMED_SIZE[0], NatsObservabilityConstants.METRIC_CONSUMED_SIZE[1], size);
    }

    public static void reportError(String context, String errorType) {
        NatsObserverContext observerContext = new NatsObserverContext(context);
        observerContext.addTag("error_type", errorType);
        NatsMetricsReporter.incrementCounter(observerContext, NatsObservabilityConstants.METRIC_ERRORS[0], NatsObservabilityConstants.METRIC_ERRORS[1]);
    }

    public void reportError(String subject, String context, String errorType) {
        NatsObserverContext observerContext = new NatsObserverContext(context, this.connection.getConnectedUrl(), subject);
        observerContext.addTag("error_type", errorType);
        NatsMetricsReporter.incrementCounter(observerContext, NatsObservabilityConstants.METRIC_ERRORS[0], NatsObservabilityConstants.METRIC_ERRORS[1]);
    }

    public static void reportStremingError(String url, String subject, String context, String errorType) {
        NatsObserverContext observerContext = new NatsObserverContext(context, url, subject);
        observerContext.addTag("error_type", errorType);
        NatsMetricsReporter.incrementCounter(observerContext, NatsObservabilityConstants.METRIC_ERRORS[0], NatsObservabilityConstants.METRIC_ERRORS[1]);
    }

    public static void reportConnectionError(String url, String errorType) {
        NatsObserverContext observerContext = new NatsObserverContext();
        observerContext.addTag("url", url);
        observerContext.addTag("error_type", errorType);
        NatsMetricsReporter.incrementCounter(observerContext, NatsObservabilityConstants.METRIC_ERRORS[0], NatsObservabilityConstants.METRIC_ERRORS[1]);
    }

    private static void incrementCounter(NatsObserverContext observerContext, String name, String desc) {
        NatsMetricsReporter.incrementCounter(observerContext, name, desc, 1);
    }

    private static void incrementCounter(NatsObserverContext observerContext, String name, String desc, int amount) {
        if (metricRegistry == null) {
            return;
        }
        metricRegistry.counter(new MetricId("nats_" + name, desc, observerContext.getAllTags())).increment((long)amount);
    }

    private static void incrementGauge(NatsObserverContext observerContext, String name, String desc) {
        if (metricRegistry == null) {
            return;
        }
        metricRegistry.gauge(new MetricId("nats_" + name, desc, observerContext.getAllTags()), new StatisticConfig[0]).increment();
    }

    private static void decrementGauge(NatsObserverContext observerContext, String name, String desc) {
        if (metricRegistry == null) {
            return;
        }
        metricRegistry.gauge(new MetricId("nats_" + name, desc, observerContext.getAllTags()), new StatisticConfig[0]).decrement();
    }
}

