/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.observability;

import java.util.Optional;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.nats.Constants;
import org.ballerinalang.nats.Utils;

public class NatsTracingUtil {
    public static void traceResourceInvocation(Strand strand, String url, String subject) {
        ObserverContext observerContext;
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        Optional observerContextOptional = ObserveUtils.getObserverContextOfCurrentFrame((Strand)strand);
        if (observerContextOptional.isPresent()) {
            observerContext = (ObserverContext)observerContextOptional.get();
        } else {
            observerContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame((Strand)strand, (ObserverContext)observerContext);
        }
        NatsTracingUtil.setTags(observerContext, url, subject);
    }

    public static void traceResourceInvocation(Strand strand, String url) {
        ObserverContext observerContext;
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        Optional observerContextOptional = ObserveUtils.getObserverContextOfCurrentFrame((Strand)strand);
        if (observerContextOptional.isPresent()) {
            observerContext = (ObserverContext)observerContextOptional.get();
        } else {
            observerContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame((Strand)strand, (ObserverContext)observerContext);
        }
        NatsTracingUtil.setTags(observerContext, url);
    }

    public static void traceResourceInvocation(Strand strand, ObjectValue producerObject, String subject) {
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        Object connection = producerObject.get(Constants.CONNECTION_OBJ);
        if (TypeChecker.getType((Object)connection).getTag() == 35) {
            ObjectValue connectionObject = (ObjectValue)connection;
            NatsTracingUtil.traceResourceInvocation(strand, Utils.getCommaSeparatedUrl(connectionObject), subject);
        } else {
            NatsTracingUtil.traceResourceInvocation(strand, "unknown", subject);
        }
    }

    public static void traceResourceInvocation(Strand strand, ObjectValue listenerOrProducerObject) {
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        Object connection = listenerOrProducerObject.get(Constants.CONNECTION_OBJ);
        if (TypeChecker.getType((Object)connection).getTag() == 35) {
            ObjectValue connectionObject = (ObjectValue)connection;
            NatsTracingUtil.traceResourceInvocation(strand, Utils.getCommaSeparatedUrl(connectionObject));
        } else {
            NatsTracingUtil.traceResourceInvocation(strand, "unknown");
        }
    }

    private static void setTags(ObserverContext observerContext, String url, String subject) {
        observerContext.addTag("url", url);
        observerContext.addTag("subject", subject);
    }

    private static void setTags(ObserverContext observerContext, String url) {
        observerContext.addTag("url", url);
    }

    private NatsTracingUtil() {
    }
}

