/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.streaming;

import io.nats.client.Connection;
import io.nats.streaming.StreamingConnection;
import io.nats.streaming.StreamingConnectionFactory;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.api.BString;

public class BallerinaNatsStreamingConnectionFactory {
    private final MapValue<BString, Object> streamingConfig;
    private final Connection natsConnection;
    private final String clusterId;
    private final String clientId;
    private static final BString ACK_TIMEOUT = StringUtils.fromString((String)"ackTimeoutInSeconds");
    private static final BString CONNECTION_TIMEOUT = StringUtils.fromString((String)"connectionTimeoutInSeconds");
    private static final BString MAX_PUB_ACKS_IN_FLIGHT = StringUtils.fromString((String)"maxPubAcksInFlight");
    private static final BString DISCOVERY_PREFIX = StringUtils.fromString((String)"discoverPrefix");

    public BallerinaNatsStreamingConnectionFactory(Connection natsConnection, String clusterId, String clientId, MapValue<BString, Object> streamingConfig) {
        this.streamingConfig = streamingConfig;
        this.natsConnection = natsConnection;
        this.clusterId = clusterId;
        this.clientId = clientId;
    }

    public StreamingConnection createConnection() throws IOException, InterruptedException {
        StreamingConnectionFactory streamingConnectionFactory = new StreamingConnectionFactory(this.clusterId, this.clientId);
        streamingConnectionFactory.setNatsConnection(this.natsConnection);
        if (this.streamingConfig != null) {
            streamingConnectionFactory.setAckTimeout(this.streamingConfig.getIntValue(ACK_TIMEOUT).longValue(), TimeUnit.SECONDS);
            streamingConnectionFactory.setConnectTimeout(this.streamingConfig.getIntValue(CONNECTION_TIMEOUT).longValue(), TimeUnit.SECONDS);
            streamingConnectionFactory.setMaxPubAcksInFlight(this.streamingConfig.getIntValue(MAX_PUB_ACKS_IN_FLIGHT).intValue());
            streamingConnectionFactory.setDiscoverPrefix(this.streamingConfig.getStringValue(DISCOVERY_PREFIX).getValue());
        }
        return streamingConnectionFactory.createConnection();
    }
}

