/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.streaming.consumer;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.nats.Constants;
import org.ballerinalang.nats.observability.NatsMetricsReporter;
import org.ballerinalang.nats.streaming.consumer.StreamingListener;

public class Attach {
    public static void streamingAttach(ObjectValue streamingListener, ObjectValue service, ObjectValue connectionObject) {
        List serviceList = (List)connectionObject.getNativeData("service_list");
        serviceList.add(service);
        ConcurrentHashMap serviceListenerMap = (ConcurrentHashMap)streamingListener.getNativeData("StreamingDispatcherList");
        boolean manualAck = Attach.getAckMode(service);
        String streamingConnectionUrl = streamingListener.getObjectValue(StringUtils.fromString((String)"connection")).get(StringUtils.fromString((String)"url")).toString();
        NatsMetricsReporter natsMetricsReporter = (NatsMetricsReporter)connectionObject.getNativeData("nats_metric_util");
        serviceListenerMap.put(service, new StreamingListener(service, manualAck, BRuntime.getCurrentRuntime(), streamingConnectionUrl, natsMetricsReporter));
    }

    private static boolean getAckMode(ObjectValue service) {
        MapValue serviceConfig = (MapValue)service.getType().getAnnotation("ballerina/nats:1.0.0", "StreamingSubscriptionConfig");
        return serviceConfig.getBooleanValue(Constants.NATS_STREAMING_MANUAL_ACK);
    }
}

