/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nats.streaming.producer;

import io.nats.streaming.AckHandler;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.nats.Utils;
import org.ballerinalang.nats.observability.NatsMetricsReporter;

public class AckListener
implements AckHandler {
    private NonBlockingCallback nonBlockingCallback;
    private String subject;
    private NatsMetricsReporter natsMetricsReporter;

    AckListener(NonBlockingCallback nonBlockingCallback, String subject, NatsMetricsReporter natsMetricsReporter) {
        this.nonBlockingCallback = nonBlockingCallback;
        this.subject = subject;
        this.natsMetricsReporter = natsMetricsReporter;
    }

    public void onAck(String nuid, Exception ex) {
        if (ex == null) {
            this.natsMetricsReporter.reportAcknowledgement(this.subject);
            this.nonBlockingCallback.setReturnValues((Object)StringUtils.fromString((String)nuid));
        } else {
            this.natsMetricsReporter.reportProducerError(this.subject, "acknowledgement");
            ErrorValue error = Utils.createNatsError("NUID: " + nuid + "; " + ex.getMessage());
            this.nonBlockingCallback.setReturnValues((Object)error);
        }
        this.nonBlockingCallback.notifySuccess();
    }
}

