/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom;

import java.util.EnumSet;
import java.util.Set;
import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNSUnawareAttribute;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.DetachPolicy;
import org.apache.axiom.core.NSAwareAttributeMatcher;
import org.apache.axiom.core.NamespaceDeclarationMatcher;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.Semantics;
import org.apache.axiom.dom.DOMAttribute;

public final class DOMSemantics
implements Semantics {
    private static final Set<NodeType> parentNodeTypes = EnumSet.of(NodeType.DOCUMENT, NodeType.NS_AWARE_ELEMENT, NodeType.NS_UNAWARE_ELEMENT, NodeType.DOCUMENT_FRAGMENT);
    public static final DOMSemantics INSTANCE = new DOMSemantics();
    public static final AttributeMatcher DOM1_ATTRIBUTE_MATCHER = new AttributeMatcher(){

        public boolean matches(CoreAttribute attr, String namespaceURI, String name) {
            return name.equals(((DOMAttribute)attr).getName());
        }

        public String getNamespaceURI(CoreAttribute attr) {
            return null;
        }

        public String getName(CoreAttribute attr) {
            return ((DOMAttribute)attr).getName();
        }

        public CoreAttribute createAttribute(CoreElement element, String namespaceURI, String name, String prefix, String value2) {
            CoreNSUnawareAttribute attr = element.coreCreateNode(CoreNSUnawareAttribute.class);
            attr.coreSetName(name);
            attr.coreSetCharacterData(value2, null);
            return attr;
        }

        public void update(CoreAttribute attr, String prefix, String value2) {
            attr.coreSetCharacterData(value2, INSTANCE);
        }
    };
    public static final AttributeMatcher DOM2_ATTRIBUTE_MATCHER = new NSAwareAttributeMatcher(INSTANCE, true, true);
    public static final AttributeMatcher NAMESPACE_DECLARATION_MATCHER = new NamespaceDeclarationMatcher(INSTANCE);
    public static final ClonePolicy<Void> DEEP_CLONE = new ClonePolicy<Void>(){

        @Override
        public Class<? extends CoreNode> getTargetNodeClass(Void options, CoreNode node) {
            return node.coreGetNodeClass();
        }

        @Override
        public boolean repairNamespaces(Void options) {
            return false;
        }

        @Override
        public boolean cloneAttributes(Void options) {
            return true;
        }

        @Override
        public boolean cloneChildren(Void options, NodeType nodeType) {
            return true;
        }

        @Override
        public void postProcess(Void options, CoreNode clone) {
        }
    };
    public static final ClonePolicy<Void> SHALLOW_CLONE = new ClonePolicy<Void>(){

        @Override
        public Class<? extends CoreNode> getTargetNodeClass(Void options, CoreNode node) {
            return node.coreGetNodeClass();
        }

        @Override
        public boolean repairNamespaces(Void options) {
            return false;
        }

        @Override
        public boolean cloneAttributes(Void options) {
            return true;
        }

        @Override
        public boolean cloneChildren(Void options, NodeType nodeType) {
            return nodeType == NodeType.NS_UNAWARE_ATTRIBUTE || nodeType == NodeType.NS_AWARE_ATTRIBUTE;
        }

        @Override
        public void postProcess(Void options, CoreNode clone) {
        }
    };

    private DOMSemantics() {
    }

    public DetachPolicy getDetachPolicy() {
        return DetachPolicy.SAME_DOCUMENT;
    }

    public boolean isUseStrictNamespaceLookup() {
        return false;
    }

    public boolean isParentNode(NodeType nodeType) {
        return parentNodeTypes.contains((Object)nodeType);
    }

    public RuntimeException toUncheckedException(CoreModelException ex) {
        throw new IllegalArgumentException("Don't know how to translate " + ex.getClass().getName());
    }
}

