/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class OMContentHandler
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler {
    private final boolean expandEntityReferences;
    private OMContainer root;
    private String dtdName;
    private String dtdPublicId;
    private String dtdSystemId;
    private StringBuilder internalSubset;
    private Map entities;
    private boolean inExternalSubset;
    private OMContainer target;
    private String[] namespaces = new String[16];
    private int namespaceCount;
    private int textNodeType = 4;
    private boolean inEntityReference;
    private int entityReferenceDepth;

    public OMContentHandler(boolean expandEntityReferences) {
        this.expandEntityReferences = expandEntityReferences;
    }

    public final void setDocumentLocator(Locator locator) {
    }

    public final void startDocument() throws SAXException {
        this.target = this.root = this.doStartDocument();
    }

    public final void endDocument() throws SAXException {
        if (this.target != this.root) {
            throw new IllegalStateException();
        }
        this.doEndDocument();
        this.target = null;
    }

    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.dtdName = name;
        this.dtdPublicId = publicId;
        this.dtdSystemId = systemId;
        this.internalSubset = new StringBuilder();
    }

    public final void elementDecl(String name, String model) throws SAXException {
        if (!this.inExternalSubset) {
            this.internalSubset.append("<!ELEMENT ");
            this.internalSubset.append(name);
            this.internalSubset.append(' ');
            this.internalSubset.append(model);
            this.internalSubset.append(">\n");
        }
    }

    public final void attributeDecl(String eName, String aName, String type, String mode, String value2) throws SAXException {
        if (!this.inExternalSubset) {
            this.internalSubset.append("<!ATTLIST ");
            this.internalSubset.append(eName);
            this.internalSubset.append(' ');
            this.internalSubset.append(aName);
            this.internalSubset.append(' ');
            this.internalSubset.append(type);
            if (value2 != null) {
                this.internalSubset.append(' ');
                this.internalSubset.append(value2);
            }
            this.internalSubset.append(">\n");
        }
    }

    public final void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (!this.inExternalSubset) {
            this.internalSubset.append("<!ENTITY ");
            this.internalSubset.append(name);
            if (publicId != null) {
                this.internalSubset.append(" PUBLIC \"");
                this.internalSubset.append(publicId);
            } else {
                this.internalSubset.append(" SYSTEM \"");
                this.internalSubset.append(systemId);
            }
            this.internalSubset.append("\">\n");
        }
    }

    public final void internalEntityDecl(String name, String value2) throws SAXException {
        if (this.entities == null) {
            this.entities = new HashMap();
        }
        this.entities.put(name, value2);
        if (!this.inExternalSubset) {
            this.internalSubset.append("<!ENTITY ");
            this.internalSubset.append(name);
            this.internalSubset.append(" \"");
            this.internalSubset.append(value2);
            this.internalSubset.append("\">\n");
        }
    }

    public final void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (!this.inExternalSubset) {
            this.internalSubset.append("<!NOTATION ");
            this.internalSubset.append(name);
            if (publicId != null) {
                this.internalSubset.append(" PUBLIC \"");
                this.internalSubset.append(publicId);
            } else {
                this.internalSubset.append(" SYSTEM \"");
                this.internalSubset.append(systemId);
            }
            this.internalSubset.append("\">\n");
        }
    }

    public final void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (!this.inExternalSubset) {
            this.internalSubset.append("<!ENTITY ");
            this.internalSubset.append(name);
            if (publicId != null) {
                this.internalSubset.append(" PUBLIC \"");
                this.internalSubset.append(publicId);
            } else {
                this.internalSubset.append(" SYSTEM \"");
                this.internalSubset.append(systemId);
            }
            this.internalSubset.append("\" NDATA ");
            this.internalSubset.append(notationName);
            this.internalSubset.append(">\n");
        }
    }

    public final void endDTD() throws SAXException {
        this.createOMDocType(this.target, this.dtdName, this.dtdPublicId, this.dtdSystemId, this.internalSubset.length() == 0 ? null : this.internalSubset.toString());
        this.internalSubset = null;
    }

    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.inEntityReference) {
            int index = this.namespaceCount * 2;
            if (index == this.namespaces.length) {
                String[] newNamespaces = new String[this.namespaces.length * 2];
                System.arraycopy(this.namespaces, 0, newNamespaces, 0, this.namespaces.length);
                this.namespaces = newNamespaces;
            }
            this.namespaces[index] = prefix;
            this.namespaces[index + 1] = uri;
            ++this.namespaceCount;
        }
    }

    public final void endPrefixMapping(String prefix) throws SAXException {
    }

    public final void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.inEntityReference) {
            int idx;
            if (localName == null || localName.trim().equals("")) {
                localName = qName.substring(qName.indexOf(58) + 1);
            }
            String prefix = (idx = qName.indexOf(58)) == -1 ? "" : qName.substring(0, idx);
            OMElement element = this.createOMElement(this.target, localName, namespaceURI, prefix, this.namespaces, this.namespaceCount);
            this.namespaceCount = 0;
            int j = atts.getLength();
            int i = 0;
            while (i < j) {
                String attrQName = atts.getQName(i);
                if (!attrQName.startsWith("xmlns")) {
                    OMNamespace ns;
                    String attrPrefix;
                    String attrNamespaceURI = atts.getURI(i);
                    idx = attrQName.indexOf(58);
                    String string2 = attrPrefix = idx == -1 ? "" : attrQName.substring(0, idx);
                    if (attrNamespaceURI.length() > 0) {
                        ns = element.findNamespace(attrNamespaceURI, attrPrefix);
                        if (ns == null) {
                            throw new SAXException("Unbound namespace " + attrNamespaceURI);
                        }
                    } else {
                        ns = null;
                    }
                    OMAttribute attr = element.addAttribute(atts.getLocalName(i), atts.getValue(i), ns);
                    attr.setAttributeType(atts.getType(i));
                }
                ++i;
            }
            this.target = element;
        }
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.inEntityReference) {
            this.completed((OMElement)this.target);
            this.target = ((OMNode)this.target).getParent();
        }
    }

    public final void startCDATA() throws SAXException {
        if (!this.inEntityReference) {
            this.textNodeType = 12;
        }
    }

    public final void endCDATA() throws SAXException {
        if (!this.inEntityReference) {
            this.textNodeType = 4;
        }
    }

    private void characterData(char[] ch, int start, int length, int nodeType) throws SAXException {
        if (!this.inEntityReference) {
            this.createOMText(this.target, new String(ch, start, length), nodeType);
        }
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.inEntityReference) {
            this.characterData(ch, start, length, this.textNodeType);
        }
    }

    public final void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.inEntityReference) {
            this.characterData(ch, start, length, 6);
        }
    }

    public final void processingInstruction(String piTarget, String data) throws SAXException {
        if (!this.inEntityReference) {
            this.createOMProcessingInstruction(this.target, piTarget, data);
        }
    }

    public final void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.inEntityReference) {
            this.createOMComment(this.target, new String(ch, start, length));
        }
    }

    public final void skippedEntity(String name) throws SAXException {
        this.createOMEntityReference(this.target, name, null);
    }

    public final void startEntity(String name) throws SAXException {
        if (this.inEntityReference) {
            ++this.entityReferenceDepth;
        } else if (name.equals("[dtd]")) {
            this.inExternalSubset = true;
        } else if (!this.expandEntityReferences) {
            this.createOMEntityReference(this.target, name, this.entities == null ? null : (String)this.entities.get(name));
            this.inEntityReference = true;
            this.entityReferenceDepth = 1;
        }
    }

    public final void endEntity(String name) throws SAXException {
        if (this.inEntityReference) {
            --this.entityReferenceDepth;
            if (this.entityReferenceDepth == 0) {
                this.inEntityReference = false;
            }
        } else if (name.equals("[dtd]")) {
            this.inExternalSubset = false;
        }
    }

    protected abstract OMContainer doStartDocument();

    protected abstract void doEndDocument();

    protected abstract void createOMDocType(OMContainer var1, String var2, String var3, String var4, String var5);

    protected abstract OMElement createOMElement(OMContainer var1, String var2, String var3, String var4, String[] var5, int var6);

    protected abstract void completed(OMElement var1);

    protected abstract void createOMText(OMContainer var1, String var2, int var3);

    protected abstract void createOMProcessingInstruction(OMContainer var1, String var2, String var3);

    protected abstract void createOMComment(OMContainer var1, String var2);

    protected abstract void createOMEntityReference(OMContainer var1, String var2, String var3);
}

