/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ProgramFileReader;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.ballerinalang.util.exceptions.ProgramFileFormatException;

public class BLangProgramLoader {
    public static ProgramFile read(Path balxFilePath) {
        ProgramFileReader programFileReader = new ProgramFileReader();
        try {
            return programFileReader.readProgram(balxFilePath);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new BLangRuntimeException("ballerina: cannot find program file '" + balxFilePath.toString() + "'", e);
        }
        catch (IOException e) {
            throw new BLangRuntimeException("ballerina: error reading program file: '" + e.getMessage() + "'", e);
        }
        catch (BLangRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProgramFileFormatException("ballerina: invalid program file format", e);
        }
    }
}

