/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang;

import java.util.Arrays;
import org.ballerinalang.bre.bvm.BVMExecutor;
import org.ballerinalang.bre.bvm.BVMScheduler;
import org.ballerinalang.connector.impl.ServerConnectorRegistry;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.persistence.RecoveryTask;
import org.ballerinalang.util.cli.ArgumentParser;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.debugger.Debugger;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BLangProgramRunner {
    public static BValue runProgram(ProgramFile programFile, String[] args) {
        PackageInfo entryPkgInfo = programFile.getEntryPackage();
        if (entryPkgInfo == null) {
            throw new BallerinaException("entry module not found in  '" + programFile.getProgramFilePath() + "'");
        }
        FunctionInfo mainFunction = entryPkgInfo.getFunctionInfo("main");
        BValue[] bValArgs = BLangProgramRunner.parseEntryFuncArgs(mainFunction, args);
        return BLangProgramRunner.runProgram(programFile, mainFunction, bValArgs);
    }

    public static BValue runProgram(ProgramFile programFile, BValue[] args) {
        PackageInfo entryPkgInfo = programFile.getEntryPackage();
        if (entryPkgInfo == null) {
            throw new BallerinaException("entry module not found in  '" + programFile.getProgramFilePath() + "'");
        }
        FunctionInfo mainFunction = entryPkgInfo.getFunctionInfo("main");
        return BLangProgramRunner.runProgram(programFile, mainFunction, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BValue runProgram(ProgramFile programFile, Debugger debugger, FunctionInfo entryFunction, BValue ... args) {
        BValue returnVal;
        BVMExecutor.invokePackageInitFunctions(programFile);
        boolean mainRunSuccessful = false;
        try {
            returnVal = BLangProgramRunner.runMainFunction(programFile, entryFunction, args);
            mainRunSuccessful = true;
        }
        finally {
            if (!mainRunSuccessful || !programFile.isServiceEPAvailable()) {
                BLangProgramRunner.stopProgram(programFile, debugger);
            }
        }
        if (returnVal != null && returnVal.getType().getTag() == 27) {
            BLangProgramRunner.stopProgram(programFile, debugger);
            return returnVal;
        }
        if (programFile.isServiceEPAvailable()) {
            BLangProgramRunner.executeListenPhase(programFile);
        }
        return returnVal;
    }

    @Deprecated
    public static BValue runProgram(ProgramFile programFile, FunctionInfo entryFunction, BValue ... args) {
        Debugger debugger = new Debugger(programFile);
        BLangProgramRunner.initDebugger(programFile, debugger);
        return BLangProgramRunner.runProgram(programFile, debugger, entryFunction, args);
    }

    public static void resumeStates(ProgramFile programFile) {
        new Thread(new RecoveryTask(programFile)).start();
    }

    private static BValue runMainFunction(ProgramFile programFile, FunctionInfo entryFunction, BValue[] args) {
        if (entryFunction == null) {
            return null;
        }
        BValue[] entryFuncResult = BVMExecutor.executeFunction(programFile, entryFunction, args);
        BVMScheduler.waitForStrandCompletion();
        return entryFuncResult[0];
    }

    private static void initDebugger(ProgramFile programFile, Debugger debugger) {
        programFile.setDebugger(debugger);
        if (debugger.isDebugEnabled()) {
            debugger.init();
            debugger.waitTillDebuggeeResponds();
        }
    }

    private static void executeListenPhase(ProgramFile programFile) {
        ServerConnectorRegistry serverConnectorRegistry = new ServerConnectorRegistry();
        programFile.setServerConnectorRegistry(serverConnectorRegistry);
        serverConnectorRegistry.initServerConnectors();
        BVMExecutor.invokePackageStartFunctions(programFile);
        serverConnectorRegistry.deploymentComplete();
    }

    private static BValue[] parseEntryFuncArgs(FunctionInfo entryFunction, String[] args) {
        BValue[] bValArgs = entryFunction != null ? ArgumentParser.extractEntryFuncArgs(entryFunction, args) : (BValue[])Arrays.stream(args).map(BString::new).toArray(BValue[]::new);
        return bValArgs;
    }

    private static void stopProgram(ProgramFile programFile, Debugger debugger) {
        if (debugger.isDebugEnabled()) {
            debugger.notifyExit();
        }
        BVMExecutor.stopProgramFile(programFile);
    }
}

