/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre;

import java.util.Map;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.exceptions.ArgumentOutOfRangeException;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.exceptions.BLangNullReferenceException;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.program.BLangVMUtils;
import org.ballerinalang.util.transactions.TransactionLocalContext;

public class NativeCallContext
implements Context {
    private Strand strand;
    private CallableUnitInfo callableUnitInfo;
    private StackFrame sf;
    private BValue returnValue;

    public NativeCallContext(Strand strand, CallableUnitInfo callableUnitInfo, StackFrame sf) {
        this.strand = strand;
        this.callableUnitInfo = callableUnitInfo;
        this.sf = sf;
    }

    @Override
    public Strand getStrand() {
        return this.strand;
    }

    @Override
    public CallableUnitInfo getCallableUnitInfo() {
        return this.callableUnitInfo;
    }

    @Override
    public StackFrame getDataFrame() {
        return this.sf;
    }

    @Override
    public Object getProperty(String key) {
        return this.strand.globalProps.get(key);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.strand.globalProps;
    }

    @Override
    public void setProperty(String key, Object value2) {
        this.strand.globalProps.put(key, value2);
    }

    @Override
    public ServiceInfo getServiceInfo() {
        return BLangVMUtils.getServiceInfo(this.strand);
    }

    @Override
    public void setServiceInfo(ServiceInfo serviceInfo) {
        BLangVMUtils.setServiceInfo(this.strand, serviceInfo);
    }

    @Override
    public boolean isInTransaction() {
        return this.strand.isInTransaction();
    }

    @Override
    public BError getError() {
        return this.strand.getError();
    }

    @Override
    public void setError(BError error2) {
        this.strand.setError(error2);
    }

    @Override
    public ProgramFile getProgramFile() {
        return this.strand.programFile;
    }

    @Override
    public long getIntArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        return this.sf.longRegs[index];
    }

    @Override
    public String getStringArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        String str = this.sf.stringRegs[index];
        if (str == null) {
            throw new BLangNullReferenceException();
        }
        return str;
    }

    @Override
    public String getNullableStringArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        return this.sf.stringRegs[index];
    }

    @Override
    public double getFloatArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        return this.sf.doubleRegs[index];
    }

    @Override
    public boolean getBooleanArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        return this.sf.intRegs[index] == 1;
    }

    @Override
    public BValue getRefArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        BRefType<?> result = this.sf.refRegs[index];
        if (result == null) {
            throw new BallerinaException("argument " + index + " is null");
        }
        return result;
    }

    @Override
    public BValue getNullableRefArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        return this.sf.refRegs[index];
    }

    @Override
    public void setReturnValues(BValue ... value2) {
        if (value2 != null && value2.length > 0) {
            this.returnValue = value2[0];
        }
    }

    @Override
    public BValue getReturnValue() {
        return this.returnValue;
    }

    @Override
    public TransactionLocalContext getLocalTransactionInfo() {
        return this.strand.getLocalTransactionContext();
    }
}

