/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Map;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.bre.bvm.BVMExecutor;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BObjectType;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BDecimal;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.ObjectTypeInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BLangVMStructs {
    public static BMap<String, BValue> createBStruct(StructureTypeInfo structInfo, Object ... values) {
        BStructureType structType = structInfo.getType();
        BMap<String, BValue> bStruct = new BMap<String, BValue>(structType);
        Map<String, BField> structFields = structType.getFields();
        int valCount = 0;
        for (BField field : structFields.values()) {
            Object value2 = values.length >= valCount + 1 ? BLangVMStructs.getBValue(field.fieldType, values[valCount]) : field.fieldType.getEmptyValue();
            bStruct.put(field.fieldName, (BValue)value2);
            ++valCount;
        }
        return bStruct;
    }

    public static BMap<String, BValue> createObject(ObjectTypeInfo objectInfo, BValue ... values) {
        BObjectType structType = objectInfo.getType();
        BMap<String, BValue> bStruct = new BMap<String, BValue>(structType);
        BValue[] vals = new BValue[values.length + 1];
        vals[0] = bStruct;
        System.arraycopy(values, 0, vals, 1, values.length);
        BVMExecutor.executeFunction(objectInfo.initializer.getPackageInfo().getProgramFile(), objectInfo.initializer, vals);
        return bStruct;
    }

    private static BValue getBValue(BType type, Object value2) {
        switch (type.getTag()) {
            case 1: {
                if (value2 instanceof Integer) {
                    return new BInteger(((Integer)value2).longValue());
                }
                if (value2 instanceof Long) {
                    return new BInteger((Long)value2);
                }
                if (!(value2 instanceof BInteger)) break;
                return (BInteger)value2;
            }
            case 2: {
                if (value2 instanceof Byte || value2 instanceof Integer || value2 instanceof Long) {
                    long longValue = ((Number)value2).longValue();
                    if (!BVM.isByteLiteral(longValue)) {
                        throw new BallerinaException(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'int' value '" + value2 + "' cannot be converted to 'byte'");
                    }
                    return new BByte(longValue);
                }
                if (!(value2 instanceof BByte)) break;
                return (BByte)value2;
            }
            case 3: {
                if (value2 == null) break;
                if (value2 instanceof Float) {
                    return new BFloat(((Float)value2).floatValue());
                }
                if (value2 instanceof Double) {
                    return new BFloat((Double)value2);
                }
                if (!(value2 instanceof BFloat)) break;
                return (BFloat)value2;
            }
            case 4: {
                if (value2 == null) break;
                if (value2 instanceof String) {
                    return new BDecimal(new BigDecimal((String)value2, MathContext.DECIMAL128));
                }
                if (value2 instanceof BigDecimal) {
                    return new BDecimal((BigDecimal)value2);
                }
                if (!(value2 instanceof BDecimal)) break;
                return (BDecimal)value2;
            }
            case 5: {
                if (value2 == null) break;
                if (value2 instanceof String) {
                    return new BString((String)value2);
                }
                if (!(value2 instanceof BString)) break;
                return (BString)value2;
            }
            case 6: {
                if (value2 == null) break;
                if (value2 instanceof Boolean) {
                    return new BBoolean((Boolean)value2);
                }
                if (!(value2 instanceof BBoolean)) break;
                return (BBoolean)value2;
            }
            default: {
                if (value2 == null || !(value2 instanceof BRefType)) break;
                return (BRefType)value2;
            }
        }
        return null;
    }
}

