/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.bre.old.WorkerState;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.runtime.threadpool.ThreadPoolFactory;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.exceptions.BLangNullReferenceException;
import org.ballerinalang.util.observability.ObserveUtils;
import org.ballerinalang.util.program.BLangVMUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BVMScheduler {
    private static final Logger breLog = LoggerFactory.getLogger(BVMScheduler.class);
    private static AtomicInteger strandCount = new AtomicInteger(0);
    private static Semaphore strandsDoneSemaphore = new Semaphore(1);

    public static void schedule(Strand strand) {
        ThreadPoolFactory.getInstance().getWorkerExecutor().submit(new CallableExecutor(strand));
    }

    public static void execute(Strand strand) {
        try {
            BVM.execute(strand);
        }
        catch (Throwable e) {
            breLog.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static void scheduleNative(NativeCallableUnit nativeCallable, Context nativeCtx, CallableUnitCallback callback) {
        ThreadPoolFactory.getInstance().getWorkerExecutor().submit(new NativeCallableExecutor(nativeCallable, nativeCtx, callback));
    }

    public static void executeNative(NativeCallableUnit nativeCallable, Context nativeCtx, CallableUnitCallback callback) {
        nativeCallable.execute(nativeCtx, callback);
    }

    public static void stateChange(Strand strand, List<Strand.State> expectedStates, Strand.State newState) {
    }

    public static void stateChange(Strand strand, Strand.State expectedState, Strand.State newState) {
    }

    static void strandCountUp() {
        if (strandCount.incrementAndGet() == 1) {
            try {
                strandsDoneSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static void strandCountDown() {
        if (strandCount.decrementAndGet() == 0) {
            strandsDoneSemaphore.release();
        }
    }

    public static void waitForStrandCompletion() {
        try {
            strandsDoneSemaphore.acquire();
            strandsDoneSemaphore.release();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class SchedulerStats {
        private LongAdder[] stateCounts = new LongAdder[6];

        public SchedulerStats() {
            for (int i = 0; i < this.stateCounts.length; ++i) {
                this.stateCounts[i] = new LongAdder();
            }
        }

        public long getReadyWorkerCount() {
            return this.stateCounts[0].longValue();
        }

        public long getRunningWorkerCount() {
            return this.stateCounts[1].longValue();
        }

        public long getExceptedWorkerCount() {
            return this.stateCounts[2].longValue();
        }

        public long getWaitingForResponseWorkerCount() {
            return this.stateCounts[3].longValue();
        }

        public long getPausedWorkerCount() {
            return this.stateCounts[4].longValue();
        }

        public long getWaitingForLockWorkerCount() {
            return this.stateCounts[5].longValue();
        }

        public void stateTransition(WorkerExecutionContext currentCtx, WorkerState newState) {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Worker Status:- \n");
            builder.append("\tREADY: " + this.getReadyWorkerCount() + "\n");
            builder.append("\tRUNNING: " + this.getRunningWorkerCount() + "\n");
            builder.append("\tEXCEPTED: " + this.getExceptedWorkerCount() + "\n");
            builder.append("\tWAITING FOR RESPONSE: " + this.getWaitingForResponseWorkerCount() + "\n");
            builder.append("\tPAUSED: " + this.getPausedWorkerCount() + "\n");
            builder.append("\tWAITING FOR LOCK: " + this.getWaitingForLockWorkerCount() + "\n");
            return builder.toString();
        }
    }

    private static class NativeCallableExecutor
    implements Runnable {
        private NativeCallableUnit nativeCallable;
        private Context nativeCtx;
        private CallableUnitCallback callback;

        public NativeCallableExecutor(NativeCallableUnit nativeCallable, Context nativeCtx, CallableUnitCallback callback) {
            this.nativeCallable = nativeCallable;
            this.nativeCtx = nativeCtx;
            this.callback = callback;
        }

        @Override
        public void run() {
            BError error2;
            Strand strand = this.nativeCtx.getStrand();
            CallableUnitInfo cui = this.nativeCtx.getCallableUnitInfo();
            BType retType = cui.getRetParamTypes()[0];
            try {
                this.nativeCallable.execute(this.nativeCtx, this.callback);
                if (strand.fp > 0) {
                    ObserveUtils.stopCallableObservation(strand);
                    if (BVM.checkIsType(this.nativeCtx.getReturnValue(), BTypes.typeError)) {
                        strand.currentFrame.handleChannelError((BRefType)this.nativeCtx.getReturnValue(), strand.peekFrame((int)1).wdChannels);
                    }
                    strand.popFrame();
                    StackFrame retFrame = strand.currentFrame;
                    BLangVMUtils.populateWorkerDataWithValues(retFrame, this.nativeCtx.getDataFrame().retReg, this.nativeCtx.getReturnValue(), retType);
                    BVMScheduler.execute(strand);
                    return;
                }
                if (BVM.checkIsType(this.nativeCtx.getReturnValue(), BTypes.typeError)) {
                    strand.currentFrame.handleChannelError((BRefType)this.nativeCtx.getReturnValue(), strand.respCallback.parentChannels);
                }
                strand.respCallback.signal();
                return;
            }
            catch (BLangNullReferenceException e) {
                error2 = BLangVMErrors.createNullRefException(this.nativeCtx.getStrand());
            }
            catch (Throwable e) {
                error2 = BLangVMErrors.createError(this.nativeCtx.getStrand(), e.getMessage());
            }
            strand.setError(error2);
            ObserveUtils.stopCallableObservation(strand);
            if (strand.fp > 0) {
                strand.currentFrame.handleChannelPanic(error2, strand.peekFrame((int)1).wdChannels);
                strand.popFrame();
            } else {
                strand.currentFrame.handleChannelPanic(error2, strand.respCallback.parentChannels);
                strand.popFrame();
            }
            BVM.handleError(strand);
            BVMScheduler.execute(strand);
        }
    }

    private static class CallableExecutor
    implements Runnable {
        private Strand strand;

        public CallableExecutor(Strand strand) {
            this.strand = strand;
        }

        @Override
        public void run() {
            try {
                BVM.execute(this.strand);
            }
            catch (Throwable e) {
                breLog.error(e.getMessage(), e);
            }
        }
    }
}

