/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.StrandCallback;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.debugger.DebugContext;
import org.ballerinalang.util.transactions.TransactionLocalContext;

public class Strand {
    private static final int DEFAULT_CONTROL_STACK_SIZE = 2000;
    private String id;
    public State state;
    public volatile boolean aborted;
    private StackFrame[] callStack;
    public int fp = -1;
    public StackFrame currentFrame;
    public ProgramFile programFile;
    private DebugContext debugContext;
    public StrandCallback respCallback;
    private BError error;
    public Map<String, Object> globalProps;
    public StrandWaitHandler strandWaitHandler;
    public FlushDetail flushDetail;
    private TransactionLocalContext transactionStrandContext;

    public Strand(ProgramFile programFile, String name, Map<String, Object> properties, StrandCallback respCallback) {
        this.programFile = programFile;
        this.respCallback = respCallback;
        this.callStack = new StackFrame[2000];
        this.state = State.NEW;
        this.globalProps = properties;
        this.id = name + "-" + UUID.randomUUID().toString();
        this.aborted = false;
        this.transactionStrandContext = null;
        this.initDebugger();
    }

    private void initDebugger() {
        if (!this.programFile.getDebugger().isDebugEnabled()) {
            return;
        }
        this.debugContext = new DebugContext();
        this.programFile.getDebugger().addStrand(this);
    }

    public String getId() {
        return this.id;
    }

    public StackFrame pushFrame(StackFrame frame) {
        this.callStack[++this.fp] = frame;
        this.currentFrame = frame;
        return this.currentFrame;
    }

    public StackFrame popFrame() {
        StackFrame poppedFrame = this.currentFrame;
        this.callStack[this.fp] = null;
        if (this.fp > 0) {
            this.currentFrame = this.callStack[--this.fp];
        } else {
            this.currentFrame = null;
            --this.fp;
        }
        return poppedFrame;
    }

    public StackFrame peekFrame(int offset) {
        StackFrame peekFrame = null;
        if (this.fp - offset >= 0 && this.fp - offset < this.callStack.length) {
            peekFrame = this.callStack[this.fp - offset];
        }
        return peekFrame;
    }

    public StackFrame getRootFrame() {
        return this.callStack[0];
    }

    public StackFrame getCurrentFrame() {
        return this.currentFrame;
    }

    public StackFrame[] getStack() {
        return this.callStack;
    }

    public void setError(BError error2) {
        this.error = error2;
    }

    public BError getError() {
        return this.error;
    }

    public boolean isInTransaction() {
        return this.transactionStrandContext != null;
    }

    public void setLocalTransactionContext(TransactionLocalContext transactionLocalContext) {
        this.transactionStrandContext = transactionLocalContext;
    }

    public TransactionLocalContext getLocalTransactionContext() {
        return this.transactionStrandContext;
    }

    public void removeLocalTransactionContext() {
        this.transactionStrandContext = null;
    }

    public void createWaitHandler(int callBacksRemaining, List<Integer> callBacksToWaitFor) {
        this.strandWaitHandler = new StrandWaitHandler(callBacksRemaining, callBacksToWaitFor);
    }

    public void acquireExecutionLock() {
        try {
            this.strandWaitHandler.executionLock.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void releaseExecutionLock() {
        this.strandWaitHandler.executionLock.release();
    }

    public DebugContext getDebugContext() {
        return this.debugContext;
    }

    public void configureFlushDetails(String[] flushChannels) {
        this.flushDetail = new FlushDetail(flushChannels);
    }

    public static class FlushDetail {
        public String[] flushChannels;
        public int flushedCount;
        public Lock flushLock;

        public FlushDetail(String[] flushChannels) {
            this.flushChannels = flushChannels;
            this.flushedCount = 0;
            this.flushLock = new ReentrantLock();
        }
    }

    public static class StrandWaitHandler {
        private Semaphore executionLock;
        boolean waitCompleted;
        List<Integer> callbacksToWaitFor;
        int callBacksRemaining;

        public StrandWaitHandler(int callBacksRemaining, List<Integer> callBacksToWaitFor) {
            this.callBacksRemaining = callBacksRemaining;
            this.callbacksToWaitFor = callBacksToWaitFor;
            this.waitCompleted = false;
            this.executionLock = new Semaphore(1);
        }
    }

    public static enum State {
        NEW,
        RUNNABLE,
        PAUSED,
        TERMINATED;

    }
}

