/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.ArrayDeque;
import java.util.Arrays;
import org.ballerinalang.bre.bvm.BVMScheduler;
import org.ballerinalang.bre.bvm.Strand;

public class VarLock {
    private ArrayDeque<Strand> current = new ArrayDeque();
    private ArrayDeque<Strand> waitingForLock = new ArrayDeque();

    public synchronized boolean lock(Strand ctx) {
        if (this.isLockFree() || this.lockedBySameContext(ctx)) {
            this.current.offerLast(ctx);
            return true;
        }
        this.waitingForLock.offerLast(ctx);
        BVMScheduler.stateChange(ctx, Arrays.asList(Strand.State.NEW, Strand.State.RUNNABLE), Strand.State.PAUSED);
        return false;
    }

    public synchronized void unlock() {
        this.current.removeLast();
        if (!this.waitingForLock.isEmpty()) {
            Strand ctx = this.waitingForLock.removeFirst();
            --ctx.currentFrame.ip;
            BVMScheduler.stateChange(ctx, Strand.State.PAUSED, Strand.State.RUNNABLE);
            BVMScheduler.schedule(ctx);
        }
    }

    private boolean isLockFree() {
        return this.current.isEmpty();
    }

    private boolean lockedBySameContext(Strand ctx) {
        return this.current.getLast() == ctx;
    }
}

