/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.List;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.bre.bvm.SafeStrandCallback;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.bre.bvm.StrandCallback;
import org.ballerinalang.bre.bvm.WorkerDataChannel;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.util.codegen.cpentries.UTF8CPEntry;

public class WaitCallbackHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean handleReturnInWait(Strand strand, BType expType, int retReg, SafeStrandCallback ... callbacks) {
        try {
            strand.acquireExecutionLock();
            if (strand.strandWaitHandler.waitCompleted) {
                boolean bl = false;
                return bl;
            }
            for (SafeStrandCallback callback : callbacks) {
                callback.acquireDataLock();
                if (callback.getStatus() == StrandCallback.CallbackStatus.NOT_RETURNED) {
                    callback.configureWaitHandler(strand, false, expType, retReg, -1);
                    callback.releaseDataLock();
                    continue;
                }
                if (callback.getStatus() == StrandCallback.CallbackStatus.VALUE_RETURNED) {
                    WaitCallbackHandler.copyReturnsInWait(strand, callback, expType, retReg);
                    strand.strandWaitHandler.waitCompleted = true;
                    callback.releaseDataLock();
                    boolean bl = true;
                    return bl;
                }
                if (callback.getStatus() == StrandCallback.CallbackStatus.ERROR_RETURN) {
                    --strand.strandWaitHandler.callBacksRemaining;
                    if (strand.strandWaitHandler.callBacksRemaining == 0) {
                        WaitCallbackHandler.copyReturnsInWait(strand, callback, expType, retReg);
                        strand.strandWaitHandler.waitCompleted = true;
                        callback.releaseDataLock();
                        boolean bl = true;
                        return bl;
                    }
                    callback.releaseDataLock();
                    continue;
                }
                --strand.strandWaitHandler.callBacksRemaining;
                if (strand.strandWaitHandler.callBacksRemaining == 0) {
                    strand.setError(callback.getErrorVal());
                    strand.strandWaitHandler.waitCompleted = true;
                    callback.releaseDataLock();
                    BVM.handleError(strand);
                    boolean bl = true;
                    return bl;
                }
                callback.releaseDataLock();
            }
        }
        finally {
            strand.releaseExecutionLock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean handleReturnInWaitMultiple(Strand strand, int retReg, List<SafeStrandCallback.WaitMultipleCallback> callbacks) {
        try {
            strand.acquireExecutionLock();
            if (strand.strandWaitHandler.waitCompleted) {
                boolean bl = false;
                return bl;
            }
            for (SafeStrandCallback.WaitMultipleCallback waitMultipleCallback : callbacks) {
                Integer keyReg = waitMultipleCallback.getKeyRegIndex();
                SafeStrandCallback callback = waitMultipleCallback.getCallback();
                callback.acquireDataLock();
                if (callback.getStatus() == StrandCallback.CallbackStatus.NOT_RETURNED) {
                    callback.configureWaitHandler(strand, true, null, retReg, keyReg);
                    callback.releaseDataLock();
                    continue;
                }
                if (callback.getStatus().returned) {
                    WaitCallbackHandler.copyReturnsInWaitMultiple(strand.currentFrame, callback, retReg, keyReg);
                    strand.strandWaitHandler.callbacksToWaitFor.remove(keyReg);
                    callback.releaseDataLock();
                    if (!strand.strandWaitHandler.callbacksToWaitFor.isEmpty()) continue;
                    boolean bl = true;
                    return bl;
                }
                strand.setError(callback.getErrorVal());
                strand.strandWaitHandler.waitCompleted = true;
                callback.releaseDataLock();
                BVM.handleError(strand);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            strand.releaseExecutionLock();
        }
        return false;
    }

    static boolean handleFlush(Strand strand, int retReg, String[] channels) {
        strand.configureFlushDetails(channels);
        for (int i = 0; i < channels.length; ++i) {
            WorkerDataChannel dataChannel = strand.currentFrame.callableUnitInfo.getDefaultWorkerInfo().getWorkerName().equals("default") ? strand.currentFrame.wdChannels.getWorkerDataChannel(channels[i]) : (strand.fp > 0 ? strand.peekFrame((int)1).wdChannels.getWorkerDataChannel(channels[i]) : strand.respCallback.parentChannels.getWorkerDataChannel(channels[i]));
            if (!dataChannel.flushChannel(strand, retReg)) continue;
            return true;
        }
        return false;
    }

    private static void copyReturnsInWaitMultiple(StackFrame sf, SafeStrandCallback strandCallback, int retReg, int keyReg) {
        String keyValue = ((UTF8CPEntry)sf.constPool[keyReg]).getValue();
        switch (strandCallback.retType.getTag()) {
            case 1: {
                ((BMap)sf.refRegs[retReg]).put(keyValue, new BInteger(strandCallback.getIntRetVal()));
                break;
            }
            case 2: {
                ((BMap)sf.refRegs[retReg]).put(keyValue, new BByte(strandCallback.getByteRetVal()));
                break;
            }
            case 3: {
                ((BMap)sf.refRegs[retReg]).put(keyValue, new BFloat(strandCallback.getFloatRetVal()));
                break;
            }
            case 5: {
                ((BMap)sf.refRegs[retReg]).put(keyValue, new BString(strandCallback.getStringRetVal()));
                break;
            }
            case 6: {
                ((BMap)sf.refRegs[retReg]).put(keyValue, new BBoolean(strandCallback.getBooleanRetVal() == 1));
                break;
            }
            default: {
                ((BMap)sf.refRegs[retReg]).put(keyValue, strandCallback.getRefRetVal());
            }
        }
    }

    private static void copyReturnsInWait(Strand strand, SafeStrandCallback strandCallback, BType expType, int retReg) {
        StackFrame sf = strand.currentFrame;
        if (expType.getTag() == 20) {
            switch (strandCallback.retType.getTag()) {
                case 1: {
                    sf.refRegs[retReg] = new BInteger(strandCallback.getIntRetVal());
                    break;
                }
                case 2: {
                    sf.refRegs[retReg] = new BByte(strandCallback.getByteRetVal());
                    break;
                }
                case 3: {
                    sf.refRegs[retReg] = new BFloat(strandCallback.getFloatRetVal());
                    break;
                }
                case 5: {
                    sf.refRegs[retReg] = new BString(strandCallback.getStringRetVal());
                    break;
                }
                case 6: {
                    sf.refRegs[retReg] = new BBoolean(strandCallback.getBooleanRetVal() == 1);
                    break;
                }
                default: {
                    sf.refRegs[retReg] = strandCallback.getRefRetVal();
                }
            }
            return;
        }
        switch (strandCallback.retType.getTag()) {
            case 1: {
                sf.longRegs[retReg] = strandCallback.getIntRetVal();
                break;
            }
            case 2: {
                sf.longRegs[retReg] = strandCallback.getByteRetVal();
                break;
            }
            case 3: {
                sf.doubleRegs[retReg] = strandCallback.getFloatRetVal();
                break;
            }
            case 5: {
                sf.stringRegs[retReg] = strandCallback.getStringRetVal();
                break;
            }
            case 6: {
                sf.intRegs[retReg] = strandCallback.getBooleanRetVal();
                break;
            }
            default: {
                sf.refRegs[retReg] = strandCallback.getRefRetVal();
            }
        }
    }
}

