/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.bre.bvm.BVMScheduler;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BRefType;

public class WorkerDataChannel {
    private Strand receiver;
    private WaitingSender waitingSender;
    private WaitingSender flushSender;
    private BRefType error;
    private BError panic;
    private int senderCounter = 0;
    private int receiverCounter = 0;
    private Lock channelLock;
    public String chnlName;
    private Queue<WorkerResult> channel = new LinkedList<WorkerResult>();

    public WorkerDataChannel() {
        this.channelLock = new ReentrantLock();
    }

    public WorkerDataChannel(String channelName) {
        this.channelLock = new ReentrantLock();
        this.chnlName = channelName;
    }

    public void acquireChannelLock() {
        this.channelLock.lock();
    }

    public void releaseChannelLock() {
        this.channelLock.unlock();
    }

    public void sendData(BRefType data) {
        this.acquireChannelLock();
        this.channel.add(new WorkerResult(data));
        ++this.senderCounter;
        if (this.receiver != null) {
            BVMScheduler.stateChange(this.receiver, Strand.State.PAUSED, Strand.State.RUNNABLE);
            BVMScheduler.schedule(this.receiver);
            this.receiver = null;
        }
        this.releaseChannelLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncSendData(BRefType data, Strand waitingCtx, int retReg) {
        try {
            this.acquireChannelLock();
            this.channel.add(new WorkerResult(data, true));
            ++this.senderCounter;
            this.waitingSender = new WaitingSender(waitingCtx, retReg, -1);
            if (this.receiver != null) {
                BVMScheduler.stateChange(this.receiver, Strand.State.PAUSED, Strand.State.RUNNABLE);
                BVMScheduler.schedule(this.receiver);
                this.receiver = null;
            } else {
                if (this.panic != null) {
                    waitingCtx.setError(this.panic);
                    BVM.handleError(waitingCtx);
                    this.panic = null;
                    boolean bl = true;
                    return bl;
                }
                if (this.error != null) {
                    waitingCtx.currentFrame.refRegs[retReg] = this.error;
                    this.error = null;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseChannelLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryTakeData(Strand ctx, BType type, int reg) {
        try {
            this.acquireChannelLock();
            WorkerResult result = this.channel.peek();
            if (result != null) {
                ++this.receiverCounter;
                this.channel.remove();
                if (result.isSync) {
                    this.waitingSender.waitingCtx.currentFrame.refRegs[this.waitingSender.returnReg] = null;
                    BVMScheduler.stateChange(this.waitingSender.waitingCtx, Strand.State.PAUSED, Strand.State.RUNNABLE);
                    BVMScheduler.schedule(this.waitingSender.waitingCtx);
                    this.waitingSender = null;
                } else if (this.flushSender != null && this.flushSender.flushCount == this.receiverCounter) {
                    this.flushSender.waitingCtx.flushDetail.flushLock.lock();
                    ++this.flushSender.waitingCtx.flushDetail.flushedCount;
                    if (this.flushSender.waitingCtx.flushDetail.flushedCount == this.flushSender.waitingCtx.flushDetail.flushChannels.length) {
                        this.flushSender.waitingCtx.currentFrame.refRegs[this.flushSender.returnReg] = null;
                        BVMScheduler.stateChange(this.flushSender.waitingCtx, Strand.State.PAUSED, Strand.State.RUNNABLE);
                        BVMScheduler.schedule(this.flushSender.waitingCtx);
                    }
                    this.flushSender.waitingCtx.flushDetail.flushLock.unlock();
                    this.flushSender = null;
                }
                BVM.copyArgValueForWorkerReceive(ctx.currentFrame, reg, type, result.value);
                boolean bl = true;
                return bl;
            }
            if (this.panic != null && this.senderCounter == this.receiverCounter + 1) {
                ++this.receiverCounter;
                ctx.setError(this.panic);
                BVM.handleError(ctx);
                boolean bl = true;
                return bl;
            }
            if (this.error != null && this.senderCounter == this.receiverCounter + 1) {
                ++this.receiverCounter;
                BVM.copyArgValueForWorkerReceive(ctx.currentFrame, reg, type, this.error);
                boolean bl = true;
                return bl;
            }
            this.receiver = ctx;
            --ctx.currentFrame.ip;
            BVMScheduler.stateChange(ctx, Strand.State.RUNNABLE, Strand.State.PAUSED);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseChannelLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushChannel(Strand ctx, int retReg) {
        this.acquireChannelLock();
        try {
            if (this.panic != null) {
                ctx.setError(this.panic);
                BVM.handleError(ctx);
                boolean bl = true;
                return bl;
            }
            if (this.error != null) {
                ctx.currentFrame.refRegs[retReg] = this.error;
                boolean bl = true;
                return bl;
            }
            if (this.receiverCounter == this.senderCounter) {
                ctx.flushDetail.flushLock.lock();
                ++ctx.flushDetail.flushedCount;
                if (ctx.flushDetail.flushedCount == ctx.flushDetail.flushChannels.length) {
                    ctx.currentFrame.refRegs[retReg] = null;
                    ctx.flushDetail.flushLock.unlock();
                    boolean bl = true;
                    return bl;
                }
                ctx.flushDetail.flushLock.unlock();
                boolean bl = false;
                return bl;
            }
            this.flushSender = new WaitingSender(ctx, retReg, this.senderCounter);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseChannelLock();
        }
    }

    public void setSendError(BRefType error2) {
        this.acquireChannelLock();
        this.error = error2;
        ++this.senderCounter;
        if (this.receiver != null) {
            BVMScheduler.stateChange(this.receiver, Strand.State.PAUSED, Strand.State.RUNNABLE);
            BVMScheduler.schedule(this.receiver);
            this.receiver = null;
        }
        this.releaseChannelLock();
    }

    public void setRecieveError(BRefType error2) {
        this.acquireChannelLock();
        this.error = error2;
        ++this.receiverCounter;
        if (this.flushSender != null) {
            this.flushSender.waitingCtx.currentFrame.refRegs[this.flushSender.returnReg] = this.error;
            BVMScheduler.stateChange(this.flushSender.waitingCtx, Strand.State.PAUSED, Strand.State.RUNNABLE);
            BVMScheduler.schedule(this.flushSender.waitingCtx);
            this.flushSender = null;
        } else if (this.waitingSender != null) {
            this.waitingSender.waitingCtx.currentFrame.refRegs[this.waitingSender.returnReg] = this.error;
            BVMScheduler.stateChange(this.waitingSender.waitingCtx, Strand.State.PAUSED, Strand.State.RUNNABLE);
            BVMScheduler.schedule(this.waitingSender.waitingCtx);
            this.waitingSender = null;
        }
        this.releaseChannelLock();
    }

    public void setSendPanic(BError panic) {
        this.acquireChannelLock();
        this.panic = panic;
        ++this.senderCounter;
        if (this.receiver != null) {
            BVMScheduler.stateChange(this.receiver, Strand.State.PAUSED, Strand.State.RUNNABLE);
            BVMScheduler.schedule(this.receiver);
            this.receiver = null;
        }
        this.releaseChannelLock();
    }

    public void setReceiverPanic(BError panic) {
        this.acquireChannelLock();
        this.panic = panic;
        ++this.receiverCounter;
        if (this.flushSender != null) {
            this.flushSender.waitingCtx.setError(this.panic);
            BVM.handleError(this.flushSender.waitingCtx);
            BVMScheduler.stateChange(this.flushSender.waitingCtx, Strand.State.PAUSED, Strand.State.RUNNABLE);
            BVMScheduler.schedule(this.flushSender.waitingCtx);
            this.flushSender = null;
        } else if (this.waitingSender != null) {
            this.waitingSender.waitingCtx.setError(this.panic);
            BVM.handleError(this.waitingSender.waitingCtx);
            BVMScheduler.stateChange(this.waitingSender.waitingCtx, Strand.State.PAUSED, Strand.State.RUNNABLE);
            BVMScheduler.schedule(this.waitingSender.waitingCtx);
            this.waitingSender = null;
        }
        this.releaseChannelLock();
    }

    public synchronized WorkerResult tryTakeData() {
        return this.channel.poll();
    }

    public static class WaitingSender {
        public Strand waitingCtx;
        public int returnReg;
        public int flushCount;

        public WaitingSender(Strand strand, int reg, int flushCount) {
            this.waitingCtx = strand;
            this.returnReg = reg;
            this.flushCount = flushCount;
        }
    }

    public static class WorkerResult {
        public BRefType value;
        public boolean isSync;

        public WorkerResult(BRefType value2) {
            this.value = value2;
        }

        public WorkerResult(BRefType value2, boolean sync) {
            this.value = value2;
            this.isSync = sync;
        }
    }
}

