/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.emitter;

import java.io.PrintStream;
import org.ballerinalang.util.codegen.ErrorTableEntry;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.Instruction;
import org.ballerinalang.util.codegen.LineNumberInfo;
import org.ballerinalang.util.codegen.LocalVariableInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.CodeAttributeInfo;
import org.ballerinalang.util.codegen.attributes.ErrorTableAttributeInfo;
import org.ballerinalang.util.codegen.attributes.LineNumberTableAttributeInfo;
import org.ballerinalang.util.codegen.attributes.LocalVariableAttributeInfo;
import org.ballerinalang.util.codegen.attributes.ParameterAttributeInfo;
import org.ballerinalang.util.codegen.attributes.VarTypeCountAttributeInfo;
import org.ballerinalang.util.codegen.cpentries.ConstantPoolEntry;
import org.ballerinalang.util.codegen.cpentries.FloatCPEntry;
import org.ballerinalang.util.codegen.cpentries.FunctionRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.IntegerCPEntry;
import org.ballerinalang.util.codegen.cpentries.PackageRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.StringCPEntry;
import org.ballerinalang.util.codegen.cpentries.UTF8CPEntry;
import org.ballerinalang.util.codegen.cpentries.WorkerDataChannelRefCPEntry;

public class BalxEmitter {
    private PrintStream printStream = System.out;

    public void emit(ProgramFile programFile) {
        this.println("################################# Begin Final balx program #################################");
        this.println("name - " + programFile.getEntryPackage().getPkgPath());
        this.println("version - " + programFile.getEntryPackage().getPackageVersion());
        this.emit(programFile.getConstPoolEntries(), "");
        this.emit(programFile.getPackageInfoEntries());
        this.emit(programFile.getAttributeInfoEntries(), "");
        this.println("################################## End Final balx program ##################################");
    }

    private void emit(ConstantPoolEntry[] constPool, String tabs) {
        this.println(tabs + "Constant pool {");
        for (int i = 0; i < constPool.length; ++i) {
            this.emit(i, constPool[i], tabs + "\t");
        }
        this.println(tabs + "}");
    }

    private void emit(int index, ConstantPoolEntry cp, String tabs) {
        this.print(tabs + index + "\t T ");
        switch (cp.getEntryType()) {
            case CP_ENTRY_UTF8: {
                this.println("CP_ENTRY_UTF8 - " + ((UTF8CPEntry)cp).getValue());
                break;
            }
            case CP_ENTRY_INTEGER: {
                this.println("CP_ENTRY_INTEGER - " + ((IntegerCPEntry)cp).getValue());
                break;
            }
            case CP_ENTRY_FLOAT: {
                this.println("CP_ENTRY_FLOAT - " + ((FloatCPEntry)cp).getValue());
                break;
            }
            case CP_ENTRY_STRING: {
                this.println("CP_ENTRY_STRING - " + ((StringCPEntry)cp).getValue());
                break;
            }
            case CP_ENTRY_PACKAGE: {
                PackageRefCPEntry pkgRefCP = (PackageRefCPEntry)cp;
                this.println("CP_ENTRY_PACKAGE - nameCPIndex - " + pkgRefCP.getNameCPIndex());
                break;
            }
            case CP_ENTRY_FUNCTION_REF: {
                this.println("CP_ENTRY_FUNCTION_REF - " + ((FunctionRefCPEntry)cp).toString());
                break;
            }
            case CP_ENTRY_ACTION_REF: {
                this.println("CP_ENTRY_ACTION_REF - ");
                break;
            }
            case CP_ENTRY_FUNCTION_CALL_ARGS: {
                this.println("CP_ENTRY_FUNCTION_CALL_ARGS - ");
                break;
            }
            case CP_ENTRY_STRUCTURE_REF: {
                this.println("CP_ENTRY_STRUCTURE_REF - ");
                break;
            }
            case CP_ENTRY_TYPE_REF: {
                this.println("CP_ENTRY_TYPE_REF - ");
                break;
            }
            case CP_ENTRY_FORK_JOIN: {
                this.println("CP_ENTRY_FORK_JOIN - ");
                break;
            }
            case CP_ENTRY_WRKR_DATA_CHNL_REF: {
                this.println("CP_ENTRY_WRKR_DATA_CHNL_REF - " + ((WorkerDataChannelRefCPEntry)cp).getUniqueName());
                break;
            }
            case CP_ENTRY_BLOB: {
                this.println("CP_ENTRY_BLOB - ");
            }
        }
    }

    private void emit(PackageInfo[] packages) {
        for (PackageInfo pkg : packages) {
            this.emit(pkg);
        }
    }

    private void emit(PackageInfo pkg) {
        this.println("Package - " + this.getStringCPValue(pkg.getConstPoolEntries(), pkg.orgNameCPIndex) + "/" + pkg.pkgPath + ":" + pkg.pkgVersion + " {");
        this.emit(pkg.getConstPoolEntries(), "\t");
        this.emit(pkg.getInstructions());
        this.emit(pkg.getFunctionInfoEntries());
        this.emit(pkg.getAttributeInfoEntries(), "\t");
        this.println("}");
    }

    private void emit(Instruction[] ins) {
        String tab = "\t";
        this.println(tab + "Instructions {");
        for (int i = 0; i < ins.length; ++i) {
            this.println("\t\t" + i + " : " + ins[i].toString());
        }
        this.println(tab + "}");
    }

    private void emit(FunctionInfo[] funcs) {
        for (FunctionInfo f : funcs) {
            this.emit(f);
        }
    }

    private void emit(FunctionInfo f) {
        this.println("Function " + f.getName() + " {");
        String tabs = "\t";
        this.println(tabs + "flags - " + f.flags);
        this.emit(f.getAttributeInfoEntries(), tabs);
        this.println("}");
    }

    private void emit(AttributeInfo[] attrs, String tabs) {
        this.println(tabs + "Attributes {");
        for (AttributeInfo a : attrs) {
            this.emit(a, tabs + "\t");
        }
        this.println(tabs + "}");
    }

    private void emit(AttributeInfo attr, String tabs) {
        this.print(tabs + attr.getKind().toString());
        switch (attr.getKind()) {
            case LOCAL_VARIABLES_ATTRIBUTE: {
                LocalVariableAttributeInfo localVarAttr = (LocalVariableAttributeInfo)attr;
                this.println(" {");
                for (LocalVariableInfo lv : localVarAttr.getLocalVariables()) {
                    this.println(tabs + "\tname - " + lv.getVariableName());
                    this.println(tabs + "\ttype - " + lv.getVariableType().toString());
                    this.println(tabs + "\tvarIndex - " + lv.getVariableIndex());
                }
                this.println(tabs + "}");
                break;
            }
            case PARAMETERS_ATTRIBUTE: {
                ParameterAttributeInfo paramAttr = (ParameterAttributeInfo)attr;
                this.println(" {");
                this.println(tabs + "\trequiredParamsCount - " + paramAttr.requiredParamsCount);
                this.println(tabs + "\tdefaultableParamsCount - " + paramAttr.defaultableParamsCount);
                this.println(tabs + "\trestParamCount - " + paramAttr.restParamCount);
                this.println(tabs + "}");
                break;
            }
            case VARIABLE_TYPE_COUNT_ATTRIBUTE: {
                VarTypeCountAttributeInfo varTypeAttr = (VarTypeCountAttributeInfo)attr;
                this.println(" {");
                this.println(tabs + "\tmaxLongVars - " + varTypeAttr.getMaxLongVars());
                this.println(tabs + "\tmaxDoubleVars - " + varTypeAttr.getMaxDoubleVars());
                this.println(tabs + "\tmaxStringVars - " + varTypeAttr.getMaxStringVars());
                this.println(tabs + "\tmaxIntVars - " + varTypeAttr.getMaxIntVars());
                this.println(tabs + "\tmaxRefVars - " + varTypeAttr.getMaxRefVars());
                this.println(tabs + "}");
                break;
            }
            case CODE_ATTRIBUTE: {
                CodeAttributeInfo codeAttr = (CodeAttributeInfo)attr;
                this.println(" {");
                this.println(tabs + "\tmaxLongLocalVars - " + codeAttr.getMaxLongLocalVars());
                this.println(tabs + "\tmaxDoubleLocalVars - " + codeAttr.getMaxDoubleLocalVars());
                this.println(tabs + "\tmaxStringLocalVars - " + codeAttr.getMaxStringLocalVars());
                this.println(tabs + "\tmaxIntLocalVars - " + codeAttr.getMaxIntLocalVars());
                this.println(tabs + "\tmaxRefLocalVars - " + codeAttr.getMaxRefLocalVars());
                this.println();
                this.println(tabs + "\tmaxLongRegs - " + codeAttr.getMaxLongRegs());
                this.println(tabs + "\tmaxDoubleRegs - " + codeAttr.getMaxDoubleRegs());
                this.println(tabs + "\tmaxStringRegs - " + codeAttr.getMaxStringRegs());
                this.println(tabs + "\tmaxIntRegs - " + codeAttr.getMaxIntRegs());
                this.println(tabs + "\tmaxRefRegs - " + codeAttr.getMaxRefRegs());
                this.println();
                this.println(tabs + "\tcodeAddrs - " + codeAttr.getCodeAddrs());
                this.println(tabs + "}");
                break;
            }
            case ERROR_TABLE: {
                ErrorTableAttributeInfo errAttr = (ErrorTableAttributeInfo)attr;
                this.println(" {");
                for (ErrorTableEntry ete : errAttr.getErrorTableEntriesList()) {
                    this.println(tabs + "\tipFrom " + tabs + "\tipTo " + tabs + "\tipTarget " + tabs + "\tregIndex " + tabs + "\t" + ete.toString());
                }
                this.println(tabs + "}");
                break;
            }
            case LINE_NUMBER_TABLE_ATTRIBUTE: {
                LineNumberTableAttributeInfo lineInfo = (LineNumberTableAttributeInfo)attr;
                this.println(" {");
                for (LineNumberInfo lineNumberInfo : lineInfo.getLineNumberInfoEntries()) {
                    this.println(tabs + "\tfileName - " + lineNumberInfo.getFileName() + tabs + "\tlineNumber - " + lineNumberInfo.getLineNumber() + tabs + "\tip - " + lineNumberInfo.getIp());
                }
                this.println(tabs + "}");
                break;
            }
            case TAINT_TABLE: 
            case ANNOTATIONS_ATTRIBUTE: 
            case DEFAULT_VALUE_ATTRIBUTE: 
            case PARAMETER_DEFAULTS_ATTRIBUTE: 
            case DOCUMENT_ATTACHMENT_ATTRIBUTE: 
            case PARAMETER_ANNOTATIONS_ATTRIBUTE: {
                this.println();
            }
        }
    }

    private String getStringCPValue(ConstantPoolEntry[] cps, int index) {
        ConstantPoolEntry cp = cps[index];
        switch (cp.getEntryType()) {
            case CP_ENTRY_UTF8: {
                return ((UTF8CPEntry)cp).getValue();
            }
            case CP_ENTRY_STRING: {
                return ((StringCPEntry)cp).getValue();
            }
        }
        return "Invalid CP Entry";
    }

    private void print(String value2) {
        this.printStream.print(value2);
    }

    private void println(String value2) {
        this.printStream.println(value2);
    }

    private void println() {
        this.printStream.println();
    }
}

