/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.old;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.bre.old.BLangScheduler;
import org.ballerinalang.bre.old.SyncCallableWorkerResponseContext;
import org.ballerinalang.bre.old.WorkerData;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.bre.old.WorkerSignal;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.program.BLangVMUtils;

public class AsyncInvocableWorkerResponseContext
extends SyncCallableWorkerResponseContext {
    private List<TargetContextInfo> targetContextInfos = new ArrayList<TargetContextInfo>();
    private boolean errored;
    private List<WorkerExecutionContext> workerExecutionContexts;
    private CallableUnitInfo callableUnitInfo;
    private boolean cancelled;

    public AsyncInvocableWorkerResponseContext(CallableUnitInfo callableUnitInfo, int workerCount) {
        super(callableUnitInfo.getRetParamTypes(), workerCount);
        this.callableUnitInfo = callableUnitInfo;
    }

    public AsyncInvocableWorkerResponseContext(CallableUnitInfo callableUnitInfo) {
        super(callableUnitInfo.getRetParamTypes(), 1);
        this.callableUnitInfo = callableUnitInfo;
    }

    public void setWorkerExecutionContexts(List<WorkerExecutionContext> workerExecutionContexts) {
        this.workerExecutionContexts = workerExecutionContexts;
    }

    @Override
    public synchronized WorkerExecutionContext signal(WorkerSignal signal) {
        if (this.cancelled) {
            return null;
        }
        return super.signal(signal);
    }

    @Override
    public synchronized WorkerExecutionContext joinTargetContextInfo(WorkerExecutionContext targetCtx, int[] retRegIndexes) {
        if (this.isFulfilled()) {
            this.onFulfillment(targetCtx, retRegIndexes, true);
            return targetCtx;
        }
        if (this.errored) {
            return this.propagateErrorToTarget(targetCtx, true);
        }
        this.targetContextInfos.add(new TargetContextInfo(targetCtx, retRegIndexes));
        return null;
    }

    private WorkerExecutionContext onFulfillment(WorkerExecutionContext targetCtx, int[] retRegIndexes, boolean runInCaller) {
        WorkerExecutionContext runInCallerCtx = null;
        BLangVMUtils.mergeResultData(this.currentSignal.getResult(), targetCtx.workerLocal, this.responseTypes, retRegIndexes);
        this.modifyDebugCommands(targetCtx, this.currentSignal.getSourceContext());
        if (!targetCtx.isRootContext()) {
            runInCallerCtx = BLangScheduler.resume(targetCtx, runInCaller);
        }
        return runInCallerCtx;
    }

    @Override
    public WorkerExecutionContext onFulfillment(boolean runInCaller) {
        this.doSuccessCallbackNotify();
        if (this.targetContextInfos.size() == 0) {
            return null;
        }
        TargetContextInfo info = this.targetContextInfos.get(0);
        WorkerExecutionContext runInCallerCtx = this.onFulfillment(info.targetCtx, info.retRegIndexes, runInCaller);
        for (int i = 1; i < this.targetContextInfos.size(); ++i) {
            info = this.targetContextInfos.get(i);
            this.onFulfillment(info.targetCtx, info.retRegIndexes, false);
        }
        return runInCallerCtx;
    }

    @Override
    protected WorkerExecutionContext propagateErrorToTarget() {
        this.errored = true;
        this.doFailCallbackNotify(null);
        if (this.targetContextInfos.size() == 0) {
            return null;
        }
        WorkerExecutionContext runInCallerCtx = this.propagateErrorToTarget(this.targetContextInfos.get((int)0).targetCtx, true);
        for (int i = 1; i < this.targetContextInfos.size(); ++i) {
            this.propagateErrorToTarget(this.targetContextInfos.get((int)i).targetCtx, false);
        }
        return runInCallerCtx;
    }

    private WorkerExecutionContext propagateErrorToTarget(WorkerExecutionContext targetCtx, boolean runInCaller) {
        return null;
    }

    public boolean isDone() {
        return this.isFulfilled() || this.errored || this.isCancelled();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean cancel() {
        if (this.isDone()) {
            return false;
        }
        if (this.workerExecutionContexts != null) {
            for (WorkerExecutionContext ctx : this.workerExecutionContexts) {
                BLangScheduler.stopWorker(ctx);
            }
            this.sendAsyncCancelErrorSignal();
            this.cancelled = true;
        }
        return this.cancelled;
    }

    private void sendAsyncCancelErrorSignal() {
        WorkerData result = BLangVMUtils.createWorkerData(this.callableUnitInfo.retWorkerIndex);
    }

    private static class TargetContextInfo {
        public WorkerExecutionContext targetCtx;
        public int[] retRegIndexes;

        public TargetContextInfo(WorkerExecutionContext targetCtx, int[] retRegIndexes) {
            this.targetCtx = targetCtx;
            this.retRegIndexes = retRegIndexes;
        }
    }
}

